package de.pfabulist.loracle.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import static de.pfabulist.roast.unchecked.Unchecked.e_;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class FolderFromResource {

    public List<String> getResourceFiles( String path )  {
        try {
            List<String> filenames = new ArrayList<>();

            try(
                    InputStream in = getResourceAsStream( path );
                    BufferedReader br = new BufferedReader( new InputStreamReader( in ) ) ) {
                String resource;

                System.out.println("br " + br );

                while( ( resource = br.readLine() ) != null ) {
                    System.out.println("br " + br );
                    filenames.add( resource );
                }

                System.out.println("  out "  );

            }
            System.out.println("  fns "  + filenames );

            return filenames;
        } catch ( IOException e ) {
            throw e_( e );
        }
    }

    public InputStream getResourceAsStream( String resource ) {
        final InputStream in
                = getContextClassLoader().getResourceAsStream( resource );
        System.out.println( "cc " + in );
        System.out.println( "class " + getClass().getResourceAsStream( resource ));

        return in == null ? getClass().getResourceAsStream( resource ) : in;
    }

    private ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}
