/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.util;

import com.google.gson.Gson;
import de.pfabulist.roast.NonnullCheck;
import de.pfabulist.roast.lang.Class_;
import de.pfabulist.roast.nio.Files_;
import de.pfabulist.roast.unchecked.Unchecked;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public class GsonFromResource {
    public <T> T read(String resourceName, Class<T> clazz) {
        int len = 3000000;
        byte[] buf = new byte[len];
        int got = 0;
        int pos = 0;
        int total = 0;
        try (InputStream in = Class_.getClass__((Object)this).getResourceAsStream_ot(resourceName);){
            while (got >= 0) {
                total += got;
                got = in.read(buf, pos, len - pos);
                pos += got;
            }
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
        return (T)new Gson().fromJson(new String(buf, 0, total, StandardCharsets.UTF_8), clazz);
    }

    public <T> T readFromFile(Path path, Class<T> clazz) {
        byte[] all = Files_.readAllBytes((Path)path);
        return (T)new Gson().fromJson(new String(all, 0, all.length, StandardCharsets.UTF_8), clazz);
    }

    public static String readResource(String resourceName) {
        byte[] buf = new byte[3000000];
        int got = 0;
        try (InputStream in = (InputStream)NonnullCheck._nn((Object)GsonFromResource.class.getResourceAsStream(resourceName));){
            int once;
            while ((once = in.read(buf, got, 3000000 - got)) >= 0) {
                got += once;
            }
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
        return new String(buf, 0, got, StandardCharsets.UTF_8);
    }
}

