package de.pfabulist.loracle.util;

import com.google.gson.Gson;
import de.pfabulist.roast.NonnullCheck;
import de.pfabulist.roast.lang.Class_;
import de.pfabulist.roast.nio.Files_;
import de.pfabulist.roast.unchecked.Unchecked;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

import static de.pfabulist.roast.NonnullCheck._nn;
import static de.pfabulist.roast.lang.Class_.getClass__;
import static de.pfabulist.roast.unchecked.Unchecked.u;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class GsonFromResource {

    public <T> T read( String resourceName, Class<T> clazz ) {
        int len = 3000000;
        byte[] buf = new byte[ len ];
        //byte[] buf2 = new byte[ 30000000 ];

        int got = 0;
        int pos = 0;
        int total = 0;
        try( InputStream in = Class_.getClass__( this ).getResourceAsStream_ot( resourceName ) ) {
            while ( got >= 0 ) {
                total += got;
                got = in.read( buf, pos, len - pos );
                pos += got;
            }
        } catch( IOException e ) {
            throw Unchecked.u( e);
        }

        return new Gson().fromJson( new String( buf, 0, total, StandardCharsets.UTF_8 ), clazz );

    }

    public <T> T readFromFile( Path path, Class<T> clazz) {
        byte[] all = Files_.readAllBytes( path );
        return new Gson().fromJson( new String( all, 0, all.length, StandardCharsets.UTF_8 ), clazz );
    }

    public static String readResource( String resourceName ) {
        byte[] buf = new byte[ 3000000 ];

        int got = 0;
        try( InputStream in = NonnullCheck._nn( GsonFromResource.class.getResourceAsStream( resourceName /*"/de/pfabulist/loracle/loracle.json" */) ) ) {
            while( true ) {
                int once = in.read( buf, got, 3000000 - got );
                if( once < 0 ) {
                    break;
                }
                got += once;
            }
        } catch( IOException e ) {
            throw Unchecked.u( e );
        }

        return new String( buf, 0, got, StandardCharsets.UTF_8 );
    }
}
