package de.pfabulist.loracle.found;

import de.pfabulist.loracle.custom.CustomCoordinates;
import de.pfabulist.loracle.custom.CustomLicenseUrl;
import de.pfabulist.loracle.custom.CustomLicense;
import de.pfabulist.loracle.custom.LoracleCustom;
import de.pfabulist.loracle.maven.Coordinates;

import java.util.Arrays;
import java.util.List;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Found implements LoracleCustom {
    @Override
    public List<CustomLicense> getCustomLicenses() {
        return Arrays.asList( new CustomLicense( "jamon", "http://jamonapi.sourceforge.net/JAMonLicense.html" ) );
    }

    @Override
    public List<CustomLicenseUrl> getUrls() {
        return Arrays.asList( new CustomLicenseUrl( "http://jamonapi.sourceforge.net/JAMonLicense.html",
                                                    "/de/pfabulist/loracle/found/jamon.txt" ),
                              new CustomLicenseUrl( "http://repo.aduna-software.org/legal/aduna-bsd.txt",
                                                    "/de/pfabulist/loracle/found/aduna-bsd.txt" ),
                              new CustomLicenseUrl( "http://asm.objectweb.org/license.html",
                                                    "/de/pfabulist/loracle/found/asm-objectweb.txt" ),
                              new CustomLicenseUrl( "http://www.bouncycastle.org/licence.html",
                                                    "/de/pfabulist/loracle/found/bouncy.txt" ),
                              new CustomLicenseUrl( "http://www.jcabi.com/LICENSE.txt",
                                                    "/de/pfabulist/loracle/found/bouncy.txt" ),
                              new CustomLicenseUrl( "http://msv.java.net/License.txt",
                                                    "/de/pfabulist/loracle/found/msv.txt" ),
                              new CustomLicenseUrl( "http://www.scala-lang.org/license.html",
                                                    "/de/pfabulist/loracle/found/scala-bsd.txt" ),
                              new CustomLicenseUrl( "http://github.com/json4s/json4s/raw/HEAD/LICENSE",
                                                    "/de/pfabulist/loracle/found/scala4s.txt" ),
                              new CustomLicenseUrl( "http://www.opensource.org/licenses/bsd-license.php",
                                                    "/de/pfabulist/loracle/found/scala4s.txt" ),
                              new CustomLicenseUrl( "https://github.com/orbeon/msv/blob/master/relaxngDatatype/copying.txt",
                                                    "/de/pfabulist/loracle/found/relaxdatatype.txt" ),
                              new CustomLicenseUrl( "http://jdbc.postgresql.org/license.html",
                                                    "/de/pfabulist/loracle/found/postgres-bsd.txt" ),
                              new CustomLicenseUrl( "http://hsqldb.org/web/hsqlLicense.html",
                                                    "/de/pfabulist/loracle/found/hsqldb.txt" ),
                              new CustomLicenseUrl( "https://github.com/hibernate/hibernate-jpa-api/blob/master/license.txt",
                                                    "/de/pfabulist/loracle/found/hibernate-jpa-api.txt" ),
                              new CustomLicenseUrl( "https://raw.githubusercontent.com/clarkware/jdepend/master/LICENSE",
                                                    "/de/pfabulist/loracle/found/jdepend.txt" ),
                              new CustomLicenseUrl( "http://antlr.org/license.html",
                                                    "/de/pfabulist/loracle/found/antlr-bsd.txt" ) );

    }

    @Override
    public List<CustomCoordinates> getCoordinates() {
        return Arrays.asList(
                CustomCoordinates.byLicense( "aopalliance:aopalliance:1.0", "aop-pd" ),
                CustomCoordinates.byLicense(  "dom4j:dom4j:1.6.1.redhat-6", "dom4j"), // pattern ?
                CustomCoordinates.byLicense( "net.jcip:jcip-annotations:1.0", "CC-BY-2.5" ),
                CustomCoordinates.byLicense( "org.apache.httpcomponents:httpclient:4.0.1", "Apache-2.0" ),
        CustomCoordinates.byLicense( "net.sourceforge.pmd:pmd-*:5.4.1",
                                        "bsd-4-clause" ),
        CustomCoordinates.byLicense( "org.scala-lang:scala*:2.10.0", // TODO verify  or via timed url ?
                                        "bsd-2-clause" ),
        CustomCoordinates.byLicense( "org.scala-lang:scala*:2.10.5", // TODO verify
                                        "bsd-2-clause" ),
//        CustomCoordinates.byLicense( "antlr:antlr:2.7.7" ), // TODO verify, before antlr has antlr-pd
//                                        "bsd-2-clause" ),
        CustomCoordinates.byLicense( "antlr:antlr:3.5.2", // TODO verify, before antlr has antlr-pd
                                        "bsd-2-clause" ),
//        CustomCoordinates.byLicense( "org.antlr:ST4:4.0.4" ), // TODO verify, before antlr has antlr-pd
//                                        "bsd-2-clause" ),
        CustomCoordinates.byLicense( "jline:jline:1.0",
                                        "bsd-2-clause" ),
//        CustomCoordinates.byLicense( "org.tachyonproject:tachyon-*:0.8.2" ),
//                                        "apache-2" ),
//        CustomCoordinates.byLicense( "com.thoughtworks.paranamer:paranamer:2.3" ), // by src header
//                                        "bsd-2-clause" ),

        CustomCoordinates.byLicense( "org.json4s:json4s-*:3.2.10",
                                        "apache-2" ),

        CustomCoordinates.byLicense( "riffle:riffle:jar:0.1-dev",
                                        "apache-2" ),  // todo: holder: Concurrent, Inc. (http://www.concurrentinc.com/)

        CustomCoordinates.byLicense( "junitperf:junitperf:1.8",
                                        "bsd-3-clause" ),

        CustomCoordinates.byLicense( "com.sun:tools:*",
                                        "cddl-1.1" ), // todo check

//        CustomCoordinates.byLicense( "asm:asm*:3.1" ),
//                                        "bsd-3-clause" ), // now license full text

        // todo: Copyright (C) 2001 Clarkware Consulting, Inc.
        // https://github.com/clarkware/junitperf

        CustomCoordinates.byLicense( "org.jvnet.jaxb2.maven2:maven-jaxb2-plugin:0.12.3", // 0.13.2
                                        "bsd-2-clause" ),

        CustomCoordinates.byUrl( "relaxngDatatype:relaxngDatatype:20020414", "https://github.com/orbeon/msv/blob/master/relaxngDatatype/copying.txt" ),
                              CustomCoordinates.byUrl( "jdepend:jdepend:*", "https://raw.githubusercontent.com/clarkware/jdepend/master/LICENSE" ),
                              CustomCoordinates.byLicense( "com.jamonapi:jamon:2.*", "jamon" ),
                              CustomCoordinates.byLicense( "org.apache.maven.plugins:maven-clean-plugin:3.0.0", "apache-2.0" ), // when there is no pom
                              CustomCoordinates.byLicense( "org.apache.maven.plugins:maven-deploy-plugin:2.8.2", "apache-2.0" ), // when there is no pom
                              CustomCoordinates.byLicense( "org.apache.maven.plugins:maven-compiler-plugin:3.5.1", "apache-2.0" ), // when there is no pom
                              CustomCoordinates.byLicense( "org.apache.maven.plugins:maven-surefire-plugin:2.19.1", "apache-2.0" ), // when there is no pom
                              CustomCoordinates.byLicense( "org.apache.maven.plugins:maven-site-plugin:3.5", "apache-2.0" ), // when there is no pom
                              CustomCoordinates.byLicense( "net.sf.jsr107cache:jsr107cache:1.0", "apache-2.0" ),
                              CustomCoordinates.byLicense( "com.oracle:javafx:*", "oracle-bcl-javase-javafx-2013" ),
                              CustomCoordinates.byUrl( "org.hibernate.javax.persistence:hibernate-jpa-2.0-api:1.0.0.Final", "https://github.com/hibernate/hibernate-jpa-api/blob/master/license.txt" ) );


    }
}
