package de.pfabulist.loracle.license;

import de.pfabulist.frex.Frex;

import java.util.Locale;
import java.util.regex.Pattern;

import static de.pfabulist.frex.Frex.txt;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

// allow strings, lowercase, numbers, -, .
// and not 'and', 'or', 'with'
public class SingleLicense extends GoodString implements LicenseID {

    static public boolean isValidString( String str ) {
        return good.matcher( str ).matches() && !blocked.matcher( str ).find();
    }

    SingleLicense( String id ) {
        super( id );
    }

    @Override
    public boolean isValid( String str ) {
        return isValidString( str );
    }

    static Pattern good =
            Frex.or( Frex.alphaLower(), Frex.number()).
            then( Frex.or( Frex.alphaLower(),
                           Frex.number(),
                           txt( '-'),
                           txt( '.')).
                    zeroOrMore() ).
                    buildPattern();

    static Pattern blocked = Frex.or( Frex.fullWord( "or" ), Frex.fullWord( "and" ), Frex.fullWord( "with" )).buildPattern();

    public static SingleLicense newStd( String in ) {
        String lower = in.toLowerCase( Locale.US );
        return new SingleLicense( lower );
    }

    @Override
    public String getId() {
        return super.good;
    }
}
