package de.pfabulist.loracle.license;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

import javax.annotation.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * a single license can be modified by adding (one or several) exception(s)
 * or a plus for "or later"
 */
public class ModifiedSingleLicense implements LicenseID {

    private final SingleLicense base;
    private final boolean orLater;
    private final List<LicenseException> exception;

    public ModifiedSingleLicense( SingleLicense singleLicense, boolean orLater, Optional<LicenseException> exception ) {
        this.exception = exception.map( Arrays::asList ).orElseGet( Collections::emptyList );
        this.base = singleLicense;
        this.orLater = orLater;
    }


    @Override
    public String getId() {

        return base + (orLater ? "+" : "" ) + //exception.map( e -> " with " + e ).orElse( "" );
                (exception.size() > 0 ? ( " with " + exception.get( 0 ).getName() ) : "");
    }

    @Override
    @SuppressFBWarnings( "NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION" )
    public boolean equals( @Nullable Object o ) {
        if( this == o ) { return true; }
        if( o == null || getClass() != o.getClass() ) { return false; }

        ModifiedSingleLicense that = (ModifiedSingleLicense) o;

        if( orLater != that.orLater ) { return false; }
        if( !base.equals( that.base ) ) { return false; }
        return exception.equals( that.exception );

    }

    @Override
    public int hashCode() {
        int result = base.hashCode();
        result = 31 * result + ( orLater ? 1 : 0 );
        result = 31 * result + exception.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return getId();
    }

    public Optional<LicenseException> getException() {
        return exception.size() > 0 ? Optional.of( exception.get(0)) : Optional.empty();
    }

    public String getBase() {
        return base.getId();
    }

    public SingleLicense getBaseLicense() {
        return base;
    }


}
