package de.pfabulist.loracle.license;

import de.pfabulist.frex.Frex;
import de.pfabulist.loracle.text.Normalizer;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static de.pfabulist.frex.Frex.txt;
import static de.pfabulist.roast.NonnullCheck._nn;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class LoLongName extends GoodString {

    private static Pattern hasOr = Frex.or( txt( " "), txt( "(") ).then( txt( "or ") ).buildCaseInsensitivePattern();

    private LoLongName( String good ) {
        super( good );
    }

    @Override
    boolean isValid( String str ) {
        return !hasOr.matcher( str ).find();
    }

    public static LoLongName newStd( String in ) {
        String longName = Normalizer.reduce( in );

        if( hasOr.matcher( longName ).find() ) {
            throw new IllegalArgumentException( "has on 'or' in it" );
        }

        return new LoLongName( longName );

    }


}
