package de.pfabulist.loracle.license;

import de.pfabulist.frex.Frex;

import java.util.Locale;
import java.util.regex.Pattern;

import static de.pfabulist.frex.Frex.txt;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class LicenseException extends GoodString {

    LicenseException( String name ) {
        super( name );
    }

    @Override
    public boolean isValid( String str ) {
        // String lower = str.toLowerCase( Locale.US );
        return good.matcher( str ).matches();
    }

    static Pattern good =
            Frex.or( Frex.alphaLower(), Frex.number()).
                    then( Frex.or( Frex.alphaLower(),
                                   Frex.number(),
                                   txt( '-'),
                                   txt( '.')).
                            zeroOrMore() ).
                    buildPattern();

    public static LicenseException newStd( String in ) {
        String lower = in.toLowerCase( Locale.US );
        return new LicenseException( lower );
    }

    public String getName() {
        return super.good;
    }
    

}
