package de.pfabulist.loracle.fulltext;

import de.pfabulist.loracle.text.Normalizer;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class UnchangedTextToLicense implements TextToLicense {
    private final String license;
    private final String licenseText;

    public UnchangedTextToLicense( String license, String licenseText ) {
        this.license = license;
        this.licenseText = Normalizer.norm( licenseText );
    }

    @Override
    public String getLicense() {
        return license;
    }

    @Override
    public boolean matches( String txt ) {
        return txt.equals( licenseText );
    }
}
