/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.text;

import com.esotericsoftware.minlog.Log;
import de.pfabulist.frex.CharacterClass;
import de.pfabulist.frex.Frex;
import de.pfabulist.roast.NonnullCheck;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Normalizer {
    private static final String WHITESPACE = Frex.or((Frex[])new Frex[]{Frex.whitespace(), Frex.txt((char)','), Frex.txt((char)'-'), Frex.txt((char)'_'), Frex.txt((char)'!'), Frex.txt((char)'\"'), Frex.txt((char)'\''), Frex.txt((char)'/'), Frex.txt((char)'('), Frex.txt((char)'*'), Frex.txt((char)')')}).buildPattern().toString();
    private static final Pattern maybe = Frex.or((Frex[])new Frex[]{Frex.fullWord((String)"License"), Frex.fullWord((String)"Licence"), Frex.fullWord((String)"Lisense"), Frex.fullWord((String)"Source"), Frex.fullWord((String)"Code"), Frex.fullWord((String)"The"), Frex.fullWord((String)"Version"), Frex.fullWord((String)"Vesion"), Frex.fullWord((String)"Software"), Frex.fullWord((String)"General"), Frex.fullWord((String)"Agreement"), Frex.fullWord((String)"Free"), Frex.fullWord((String)"Open"), Frex.fullWord((String)"Public"), Frex.fullWord((String)"General"), Frex.fullWord((String)"Copyright"), Frex.fullWord((String)"Like"), Frex.fullWord((String)"v")}).buildCaseInsensitivePattern();
    public static final Pattern spaces = Frex.whitespace().atLeast(2).buildPattern();
    private static final Pattern vVersion = Frex.txt((String)"v").then((Frex)Frex.or((Frex[])new Frex[]{Frex.number(), Frex.txt((char)'.'), Frex.txt((char)',')}).oneOrMore()).buildCaseInsensitivePattern();
    private static final Pattern version = Frex.or((Frex[])new Frex[]{Frex.number(), Frex.txt((char)'.')}).oneOrMore().buildCaseInsensitivePattern();
    private static final Pattern wordVversion = Frex.alpha().oneOrMore().var((Enum)WordVersionVariables.word).then(Frex.txt((String)"v")).then(Frex.or((Frex[])new Frex[]{Frex.number(), Frex.txt((char)'.')}).oneOrMore().var((Enum)WordVersionVariables.version)).buildCaseInsensitivePattern();
    private static final Pattern wordVersion = Frex.alpha().oneOrMore().var((Enum)WordVersionVariables.word).then(Frex.or((Frex[])new Frex[]{Frex.number(), Frex.txt((char)'.')}).oneOrMore().var((Enum)WordVersionVariables.version)).buildCaseInsensitivePattern();
    private static final Pattern htmlws = Frex.or((Frex[])new Frex[]{Frex.whitespace(), Frex.txt((char)'\r'), Frex.txt((char)'\n')}).oneOrMore().buildPattern();
    private static final String urlspecial = Frex.txt((char)':').or((CharacterClass)Frex.txt((char)'/')).or((CharacterClass)Frex.txt((char)'*')).or((CharacterClass)Frex.txt((char)'\"')).or((CharacterClass)Frex.txt((char)'<')).or((CharacterClass)Frex.txt((char)'>')).or((CharacterClass)Frex.txt((char)'?')).or((CharacterClass)Frex.txt((char)'\\')).or((CharacterClass)Frex.txt((char)' ')).buildPattern().toString();
    public static List<String> tooSimpleLongNames = Arrays.asList("map", "par", "free", "foundation", "fsf", "initial developer", "wide", "attribution", "only", "attribution only", "hp", "microsoft", "json", "closed", "government", "doc", "directory", "jetty", "sequence", "fork", "open", "regexp", "berkeley");

    static String normalizeNumber(String num) {
        if (num.endsWith(".0")) {
            return Normalizer.normalizeNumber(num.substring(0, num.length() - 2));
        }
        return num;
    }

    static void addNumber(StringBuilder sb, String num) {
        if (num.endsWith(".0")) {
            sb.append(num.substring(0, num.length() - 2));
        } else {
            sb.append(num);
        }
    }

    public static String reduce(String in) {
        StringBuilder sb = new StringBuilder();
        for (String word : in.toLowerCase(Locale.US).split(WHITESPACE)) {
            if (!word.isEmpty() && !maybe.matcher(word).matches()) {
                if (vVersion.matcher(word).matches()) {
                    if (!word.equals("v.")) {
                        sb.append(Normalizer.normalizeNumber(word.substring(1)));
                    }
                } else {
                    Matcher matcher = wordVversion.matcher(word);
                    if (matcher.matches()) {
                        sb.append(matcher.group("word"));
                        sb.append(" ");
                        sb.append(Normalizer.normalizeNumber((String)NonnullCheck._nn((Object)matcher.group("version"))));
                    } else {
                        Matcher wv = wordVersion.matcher(word);
                        if (wv.matches()) {
                            sb.append(wv.group("word"));
                            sb.append(" ");
                            Normalizer.addNumber(sb, (String)NonnullCheck._nn((Object)wv.group("version")));
                        } else {
                            Normalizer.addNumber(sb, word);
                        }
                    }
                }
            }
            sb.append(" ");
        }
        String ret = sb.toString().trim();
        if (!ret.isEmpty() && !version.matcher(ret).matches()) {
            return spaces.matcher(ret).replaceAll(" ");
        }
        Log.debug((String)("license name composed of fill words only: " + in));
        return spaces.matcher(in.toLowerCase(Locale.US)).replaceAll(" ");
    }

    public static String trim(String in) {
        return in.toLowerCase(Locale.US).replaceAll(",", " ").trim();
    }

    public static String norm(String txt) {
        return Arrays.stream(txt.split("\n")).map(l -> {
            if ((l = l.trim()).startsWith("*")) {
                return l.substring(1).trim();
            }
            if (l.startsWith("//")) {
                return l.substring(2).trim();
            }
            if (l.startsWith("!")) {
                return l.substring(1).trim();
            }
            return l;
        }).collect(Collectors.joining(" ")).replaceAll(htmlws.toString(), " ");
    }

    public static String toFilename(String str) {
        return str.replaceAll(urlspecial, "_");
    }

    static enum UrlVeriables {
        relevant;

    }

    static enum WordVersionVariables {
        word,
        version;

    }
}

