/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.maven;

import de.pfabulist.frex.CharacterClass;
import de.pfabulist.frex.Frex;
import de.pfabulist.roast.NonnullCheck;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;

public class Coordinates {
    public static final Pattern snapshot = Frex.any().oneOrMore().lazy().var((Enum)SnapshotVariables.base).then(Frex.digit().times(8)).then((Frex)Frex.txt((char)'.')).then(Frex.digit().times(6)).then((Frex)Frex.txt((char)'-')).then((Frex)Frex.digit().oneOrMore()).buildCaseInsensitivePattern();
    private final String coo;

    public Coordinates(String groupId, String artifactId, String version) {
        this.coo = groupId + ":" + artifactId + ":" + version;
        if (groupId.isEmpty() || artifactId.isEmpty() || version.isEmpty()) {
            throw new IllegalArgumentException("not a legal coordinates, one of group, artifact, version is empty");
        }
        if (groupId.contains(":") || artifactId.contains(":") || version.contains(":")) {
            throw new IllegalArgumentException("not a legal coordinates, one of group, artifact, contains a ':' ");
        }
    }

    public static Coordinates valueOf(String str) {
        String[] parts = str.split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException("not legal coordinates group:arti:version, got: " + str);
        }
        if (parts.length == 3) {
            return new Coordinates((String)NonnullCheck._nn((Object)parts[0]), (String)NonnullCheck._nn((Object)parts[1]), (String)NonnullCheck._nn((Object)parts[2]));
        }
        if (parts.length == 4) {
            return new Coordinates((String)NonnullCheck._nn((Object)parts[0]), (String)NonnullCheck._nn((Object)parts[1]), (String)NonnullCheck._nn((Object)parts[3]));
        }
        if (parts.length == 5) {
            return new Coordinates((String)NonnullCheck._nn((Object)parts[0]), (String)NonnullCheck._nn((Object)parts[1]), (String)NonnullCheck._nn((Object)parts[4]));
        }
        throw new IllegalArgumentException("not legal coordinates, too many ':' " + str);
    }

    public static Coordinates valueOf(Artifact arti) {
        return new Coordinates((String)NonnullCheck._nn((Object)arti.getGroupId()), (String)NonnullCheck._nn((Object)arti.getArtifactId()), (String)NonnullCheck._nn((Object)arti.getVersion()));
    }

    public String getGroupId() {
        String[] parts = this.coo.split(":");
        return (String)NonnullCheck._nn((Object)parts[0]);
    }

    public String getArtifactId() {
        String[] parts = this.coo.split(":");
        return (String)NonnullCheck._nn((Object)parts[1]);
    }

    public String getVersion() {
        String[] parts = this.coo.split(":");
        return (String)NonnullCheck._nn((Object)parts[2]);
    }

    @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinates that = (Coordinates)o;
        return this.coo.equals(that.coo);
    }

    public int hashCode() {
        return this.coo.hashCode();
    }

    public String toString() {
        return this.coo;
    }

    public boolean matches(Coordinates other) {
        if (!this.coo.contains("*")) {
            return this.equals(other);
        }
        ArrayList<String> txt = new ArrayList<String>(Arrays.asList(this.coo.split("\\*")));
        if (this.coo.endsWith("*")) {
            txt.add("");
        }
        if (((String)NonnullCheck._nn(txt.get(0))).isEmpty()) {
            throw new IllegalArgumentException("group must not start with *");
        }
        Pattern pat = txt.subList(1, txt.size()).stream().map(Frex::txt).reduce(Frex.txt((String)((String)NonnullCheck._nn(txt.get(0)))), (f, g) -> f.then((Frex)Frex.anyBut((CharacterClass)Frex.txt((char)':')).zeroOrMore()).then(g)).buildCaseInsensitivePattern();
        return pat.matcher(other.coo).matches();
    }

    public boolean isSnapshot() {
        return snapshot.matcher(this.getVersion()).matches();
    }

    public Path getSnapshotTolerantDir(Path base) {
        Matcher matcher = snapshot.matcher(this.getVersion());
        if (matcher.matches()) {
            return (Path)NonnullCheck._nn((Object)((Path)NonnullCheck._nn((Object)((Path)NonnullCheck._nn((Object)base.resolve(this.getGroupId().replace('.', '/')))).resolve(this.getArtifactId()))).resolve(matcher.group("base") + "-SNAPSHOT"));
        }
        return (Path)NonnullCheck._nn((Object)((Path)NonnullCheck._nn((Object)((Path)NonnullCheck._nn((Object)base.resolve(this.getGroupId().replace('.', '/')))).resolve(this.getArtifactId()))).resolve(this.getVersion()));
    }

    public String toFilename() {
        return this.coo.replace(":", "_");
    }

    static enum SnapshotVariables {
        base;

    }
}

