/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license.known;

import de.pfabulist.frex.Frex;
import de.pfabulist.loracle.license.GoodString;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoUrl
extends GoodString {
    public static Pattern urlPattern = Frex.or((Frex[])new Frex[]{Frex.txt((String)"http://"), Frex.txt((String)"https://")}).zeroOrOnce().then((Frex)Frex.txt((String)"www.").zeroOrOnce()).then(Frex.any().oneOrMore().lazy().var((Enum)UrlVeriables.relevant)).then((Frex)Frex.txt((String)".").then((Frex)Frex.alpha().oneOrMore()).zeroOrOnce()).buildCaseInsensitivePattern();

    LoUrl(String url) {
        super(url);
    }

    @Override
    public boolean isValid(String str) {
        return LoUrl.getReleventUrlPart(str).isPresent();
    }

    public static LoUrl newStd(String in) {
        return new LoUrl(LoUrl.getReleventUrlPart(in).orElseThrow(() -> new IllegalArgumentException("no relevant path part")));
    }

    public static Optional<String> getReleventUrlPart(String str) {
        String lower = str.toLowerCase(Locale.US);
        Matcher matcher = urlPattern.matcher(lower);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        return Optional.ofNullable(matcher.group(UrlVeriables.relevant.toString()));
    }

    public static enum UrlVeriables {
        relevant;

    }
}

