/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license.known;

import de.pfabulist.frex.Frex;
import de.pfabulist.loracle.license.GoodString;
import de.pfabulist.loracle.text.Normalizer;
import java.util.regex.Pattern;

public class LoLongName
extends GoodString {
    private static Pattern hasOr = Frex.or((Frex[])new Frex[]{Frex.txt((String)" "), Frex.txt((String)"(")}).then(Frex.txt((String)"or ")).buildCaseInsensitivePattern();

    private LoLongName(String good) {
        super(good);
    }

    @Override
    public boolean isValid(String str) {
        return !hasOr.matcher(str).find();
    }

    public static LoLongName newStd(String in) {
        String longName = Normalizer.reduce(in);
        if (hasOr.matcher(longName).find()) {
            throw new IllegalArgumentException("has on 'or' in it");
        }
        return new LoLongName(longName);
    }
}

