/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license.known;

import de.pfabulist.loracle.license.known.LicenseDefinitionSource;
import java.util.Optional;

public class LicenseAttributes {
    private String attis = "S O 2 3 F L W  ";

    public boolean isSPDX() {
        return this.attis.charAt(1) == 's';
    }

    public void setSPDX(boolean on) {
        if (on) {
            this.set(1, 's');
        }
    }

    public void setSource(LicenseDefinitionSource src) {
        this.set(1, src.toString().charAt(0));
    }

    public void setFromFedora() {
        this.set(1, 'f');
    }

    public void setFromDeja() {
        this.set(1, 'd');
    }

    public void setFromIFross() {
        this.set(1, 'i');
    }

    public Optional<Boolean> isCopyLeft() {
        return this.get(11);
    }

    public boolean isCopyLeftDef() {
        return this.isCopyLeft().orElse(false);
    }

    public void setCopyLeft(boolean on) {
        this.set(11, on);
    }

    public Optional<Boolean> isOsiApproved() {
        return this.get(3);
    }

    public void setOsiApproved(boolean on) {
        this.set(3, on);
    }

    public Optional<Boolean> isFedoraApproved() {
        return this.get(9);
    }

    public void setFedoraApproved(boolean on) {
        this.set(9, on);
    }

    public Optional<Boolean> isGpl2Compatible() {
        return this.get(5);
    }

    public void setGpl2Compatible(boolean on) {
        this.set(5, on);
    }

    public Optional<Boolean> isGpl3Compatible() {
        return this.get(7);
    }

    public void setGpl3Compatible(boolean on) {
        this.set(7, on);
    }

    public void setWeakCopyLeft(boolean on) {
        this.set(13, on);
    }

    private Optional<Boolean> get(int idx) {
        switch (this.attis.charAt(idx)) {
            case '+': {
                return Optional.of(true);
            }
            case '-': {
                return Optional.of(false);
            }
        }
        return Optional.empty();
    }

    private void set(int idx, boolean on) {
        this.attis = this.attis.substring(0, idx) + (on ? "+" : "-") + this.attis.substring(idx + 1, this.attis.length());
    }

    private void set(int idx, char on) {
        this.attis = this.attis.substring(0, idx) + on + this.attis.substring(idx + 1, this.attis.length());
    }

    public LicenseDefinitionSource getDefinitionSource() {
        return new LicenseDefinitionSource("" + this.attis.charAt(1));
    }
}

