/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license.known;

import de.pfabulist.frex.Frex;
import de.pfabulist.loracle.license.AlternativeLicense;
import de.pfabulist.loracle.license.AlternativeParser;
import de.pfabulist.loracle.license.CompositeLicense;
import de.pfabulist.loracle.license.LicenseException;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.ModifiedSingleLicense;
import de.pfabulist.loracle.license.SPDXParser;
import de.pfabulist.loracle.license.SingleLicense;
import de.pfabulist.loracle.license.known.ExistingLicense;
import de.pfabulist.loracle.license.known.LicenseAttributes;
import de.pfabulist.loracle.license.known.LicenseDefinitionSource;
import de.pfabulist.loracle.license.known.LoLongName;
import de.pfabulist.loracle.maven.Coordinates;
import de.pfabulist.roast.collection.Map_;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"})
public class LOracleKnown {
    private static Pattern hasOr = Frex.or((Frex[])new Frex[]{Frex.txt((String)" "), Frex.txt((String)"(")}).then(Frex.txt((String)"or ")).buildCaseInsensitivePattern();
    private Map<String, More> singles = new TreeMap<String, More>(String::compareTo);
    private Map<String, Boolean> licenseExceptions = new TreeMap<String, Boolean>(String::compareTo);
    private Map<String, More> composites = new TreeMap<String, More>(String::compareTo);
    private List<String> tooSimpleLongNames = new ArrayList<String>();
    private transient Map<String, LicenseID> longNameMapper = new HashMap<String, LicenseID>();

    public Optional<ExistingLicense> getExistingSingle(SingleLicense loLicenseId) {
        return Optional.ofNullable(this.singles.get(loLicenseId.toString())).map(more -> new ExistingLicense(this, loLicenseId, (More)more));
    }

    public Optional<LicenseException> getExistingExclude(LicenseException exclude) {
        if (Map_.r_(this.licenseExceptions).get_o((Object)exclude.getName()).isPresent()) {
            return Optional.of(exclude);
        }
        return Optional.empty();
    }

    public Optional<ExistingLicense> getExistingLicense(String str) {
        try {
            LoLongName ll = LoLongName.newStd(str);
            LicenseID id = this.longNameMapper.get(ll.toString());
            if (id != null) {
                Optional<ExistingLicense> ex = this.getExistingLicense(id);
                if (!ex.isPresent()) {
                    throw new IllegalArgumentException("must be there");
                }
                return ex;
            }
        }
        catch (Exception ll) {
            // empty catch block
        }
        Optional<ExistingLicense> ext = new SPDXParser().parse(str).flatMap(this::getExistingLicense);
        if (ext.isPresent()) {
            return ext;
        }
        return new AlternativeParser().parse(str).flatMap(this::getExistingLicense);
    }

    public Optional<ExistingLicense> getExistingLicense(LicenseID lid) {
        if (lid instanceof SingleLicense) {
            return this.getExistingSingle((SingleLicense)lid);
        }
        if (lid instanceof ModifiedSingleLicense) {
            return this.getExistingModified((ModifiedSingleLicense)lid);
        }
        if (lid instanceof CompositeLicense) {
            return this.getExistingComposite((CompositeLicense)lid);
        }
        if (lid instanceof AlternativeLicense) {
            return this.getExistingAlternative((AlternativeLicense)lid);
        }
        throw new IllegalStateException("unknown type of license " + lid.getClass());
    }

    private Optional<ExistingLicense> getExistingAlternative(AlternativeLicense lid) {
        return this.longNameMapperGet(lid).flatMap(this::getExistingLicense);
    }

    private Optional<LicenseID> longNameMapperGet(LicenseID li) {
        return Optional.ofNullable(this.longNameMapper.get(LoLongName.newStd(li.toString()).toString()));
    }

    private void longNameMapperPut(LicenseID li, LicenseID to) {
        this.longNameMapperGet(li).ifPresent(r -> {
            throw new IllegalArgumentException("already in long names: " + li);
        });
        if (to.isAlternative()) {
            throw new IllegalArgumentException("dont map it to a alternative: " + to);
        }
        this.longNameMapper.put(LoLongName.newStd(li.toString()).toString(), to);
    }

    private Optional<ExistingLicense> getExistingComposite(CompositeLicense license) {
        More more = this.composites.get(license.getId().toString());
        if (more != null) {
            return Optional.of(new ExistingLicense(this, license, more));
        }
        Optional<LicenseID> alt = this.longNameMapperGet(license);
        if (alt.isPresent()) {
            return this.getExistingLicense(alt.get());
        }
        Optional<ExistingLicense> leftex = this.getExistingLicense(license.getLeft());
        Optional<ExistingLicense> rightex = this.getExistingLicense(license.getRight());
        if (!leftex.isPresent() || !rightex.isPresent()) {
            return Optional.empty();
        }
        CompositeLicense coex = new CompositeLicense(license.isOr(), leftex.get().getLicenseId(), rightex.get().getLicenseId());
        if (!coex.equals(license)) {
            Optional<ExistingLicense> ret = this.getExistingLicense(coex);
            ret.ifPresent(el -> this.longNameMapperPut(license, el.getLicenseId()));
            return ret;
        }
        more = new More(new LicenseDefinitionSource("c"));
        this.composites.put(license.toString(), more);
        this.longNameMapperPut(license, license);
        return Optional.of(new ExistingLicense(this, license, more));
    }

    private Optional<ExistingLicense> getExistingModified(ModifiedSingleLicense modi) {
        More more = this.composites.get(modi.getId().toString());
        if (more != null) {
            return Optional.of(new ExistingLicense(this, modi, more));
        }
        Optional<LicenseID> alt = this.longNameMapperGet(modi);
        if (alt.isPresent()) {
            return this.getExistingLicense(alt.get());
        }
        if (modi.isAlternative()) {
            return Optional.empty();
        }
        LicenseID base = modi.getBaseLicense();
        Optional<ExistingLicense> existingBase = this.getExistingLicense(base);
        if (!existingBase.isPresent()) {
            return Optional.empty();
        }
        Optional<LicenseException> ex = modi.getException();
        if (ex.isPresent() && !this.getExistingExclude(ex.get()).isPresent()) {
            return Optional.empty();
        }
        more = new More(existingBase.get().getMore().getDefinitionSource());
        this.composites.put(modi.getId().toString(), more);
        this.longNameMapperPut(modi, modi);
        return Optional.of(new ExistingLicense(this, modi, more));
    }

    public boolean hasSingleLicense(SingleLicense lic) {
        return this.singles.containsKey(lic.toString());
    }

    public boolean isUsed(SingleLicense id, LoLongName name) {
        try {
            this.singles.forEach((license, more) -> {
                if (!id.toString().equals(license)) {
                    ((More)more).longNames.forEach(ln -> {
                        if (ln.equals(name.toString())) {
                            throw new IllegalArgumentException("old long name " + ln);
                        }
                    });
                }
            });
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public ExistingLicense addSingle(SingleLicense li, LicenseDefinitionSource src) {
        if (this.singles.get(li.toString()) != null) {
            throw new IllegalArgumentException("old single license " + li);
        }
        this.getExistingLicense(li.toString()).ifPresent(c -> {
            throw new IllegalArgumentException("exists already, old: " + c);
        });
        More more = new More(src);
        more.longNames.add(LoLongName.newStd(li.toString()).toString());
        this.singles.put(li.toString(), more);
        this.longNameMapperPut(li, li);
        return new ExistingLicense(this, li, more);
    }

    public void addShortCut(LoLongName name, ExistingLicense li) {
        if (this.longNameMapper.get(name.toString()) != null) {
            throw new IllegalArgumentException("is already a short cut");
        }
        this.longNameMapper.put(name.toString(), li.getLicenseId());
    }

    public void addUrl(SingleLicense id, String url) {
        More more = this.singles.get(id.toString());
        if (more == null) {
            throw new IllegalArgumentException("not a single license " + id);
        }
        more.urls.add(url);
    }

    public void addException(LicenseException ex) {
        this.licenseExceptions.put(ex.toString(), true);
    }

    public Stream<Map.Entry<String, More>> getSingleStream() {
        return this.singles.entrySet().stream();
    }

    public LicenseAttributes getAttributes(LicenseID id) {
        Optional<ExistingLicense> ex = this.getExistingLicense(id);
        if (!ex.isPresent()) {
            throw new IllegalArgumentException("not a single license " + id);
        }
        return ex.get().getMore().attributes;
    }

    public LOracleKnown speedUp() {
        if (!this.longNameMapper.isEmpty()) {
            throw new IllegalStateException("can only be called after json construction");
        }
        this.singles.forEach((name, more) -> {
            SingleLicense lid = new SingleLicense((String)name);
            ((More)more).longNames.forEach(l -> this.longNameMapper.putIfAbsent((String)l, lid));
        });
        this.composites.forEach((name, more) -> {
            LicenseID lid = new SPDXParser().parse_ot((String)name);
            ((More)more).longNames.forEach(l -> this.longNameMapper.putIfAbsent((String)l, lid));
        });
        return this;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class More {
        public LicenseAttributes attributes;
        public List<String> urls = new ArrayList<String>();
        private List<String> longNames = new ArrayList<String>();
        public List<Coordinates> specific = new ArrayList<Coordinates>();
        public Set<String> couldbeName = new HashSet<String>();
        public Set<String> couldbeUrl = new HashSet<String>();

        public More(LicenseDefinitionSource src) {
            this.attributes = new LicenseAttributes();
            this.attributes.setSource(src);
        }

        public void addLongName(LoLongName name) {
            if (!this.longNames.contains(name.toString())) {
                this.longNames.add(name.toString());
            }
        }

        public LicenseDefinitionSource getDefinitionSource() {
            return this.attributes.getDefinitionSource();
        }

        public List<String> getLongNames() {
            return this.longNames;
        }
    }
}

