/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license.known;

import de.pfabulist.loracle.license.LicenseException;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.MappedLicense;
import de.pfabulist.loracle.license.SPDXParser;
import de.pfabulist.loracle.license.SingleLicense;
import de.pfabulist.loracle.license.known.LOracleKnown;
import java.util.Locale;
import java.util.Optional;

public class LOracle2 {
    public static Optional<SingleLicense> getExistingSingle(LOracleKnown ldata, String name) {
        String lower = name.trim().toLowerCase(Locale.US);
        SingleLicense single = new SingleLicense(lower);
        return ldata.getExistingSingle(single).map(m -> single);
    }

    public static LicenseException getExceptionOrThrow(LOracleKnown ldata, String ex) {
        String lower = ex.trim().toLowerCase(Locale.US);
        LicenseException exclude = new LicenseException(lower);
        return ldata.getExistingExclude(exclude).orElseThrow(() -> new IllegalArgumentException("no such exception: " + ex));
    }

    public static MappedLicense getExistingSingleByName(LOracleKnown ldata, String name) {
        if (name.isEmpty()) {
            return MappedLicense.empty("no name");
        }
        try {
            LicenseID sid = new SPDXParser().parse_ot(name);
            if (LOracle2.getExistingSingle(ldata, sid.toString()).isPresent()) {
                return MappedLicense.of(sid, "by parsed name: " + name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MappedLicense.empty();
    }
}

