/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license.known;

import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.known.LOracleKnown;
import de.pfabulist.loracle.license.known.LoLongName;
import java.util.Optional;

public class ExistingLicense {
    private final LOracleKnown all;
    private final LicenseID license;
    private final LOracleKnown.More data;

    public ExistingLicense(LOracleKnown all, LicenseID license, LOracleKnown.More data) {
        this.all = all;
        this.license = license;
        this.data = data;
    }

    public void addAlternativeName(LoLongName alternativeName) {
        Optional<ExistingLicense> before = this.all.getExistingLicense(alternativeName.toString());
        if (before.isPresent()) {
            if (before.get().getLicenseId().equals(this.license)) {
                return;
            }
            throw new IllegalArgumentException("already in db " + alternativeName);
        }
        this.data.addLongName(alternativeName);
        this.all.addShortCut(alternativeName, this);
        if (alternativeName.toString().endsWith("only")) {
            try {
                this.addAlternativeName(LoLongName.newStd(alternativeName.toString().replace("only", "")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public LOracleKnown.More getMore() {
        return this.data;
    }

    public LicenseID getLicenseId() {
        return this.license;
    }
}

