/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.frex.Frex;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.LicenseName;
import java.util.Locale;
import java.util.regex.Pattern;

public class SingleLicense
implements LicenseID {
    private final LicenseName name;
    static Frex goodFrex = Frex.or((Frex[])new Frex[]{Frex.alphaLower(), Frex.number()}).then((Frex)Frex.or((Frex[])new Frex[]{Frex.alphaLower(), Frex.number(), Frex.txt((char)'-'), Frex.txt((char)'.')}).zeroOrMore());
    static Pattern good = goodFrex.buildPattern();
    static Frex badFrex = Frex.or((Frex[])new Frex[]{Frex.fullWord((String)"or"), Frex.fullWord((String)"and"), Frex.fullWord((String)"with")});
    static Pattern blocked = badFrex.buildCaseInsensitivePattern();

    public static boolean isValidString(String str) {
        return good.matcher(str).matches() && !blocked.matcher(str).find();
    }

    public SingleLicense(String id) {
        this.name = new LicenseName(id);
        if (!this.isValid(id)) {
            throw new IllegalArgumentException("str passes LicenseName validation but not SingleLicense validation " + id);
        }
    }

    public boolean isValid(String str) {
        return SingleLicense.isValidString(str);
    }

    public static Frex getGoodFrex() {
        return goodFrex;
    }

    public Frex getBadFrex() {
        return badFrex;
    }

    public static SingleLicense newStd(String in) {
        String lower = in.toLowerCase(Locale.US);
        return new SingleLicense(lower);
    }

    @Override
    public LicenseName getId() {
        return this.name;
    }

    @Override
    public int compareTo(LicenseID o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleLicense that = (SingleLicense)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name.toString();
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean isAlternative() {
        return false;
    }
}

