/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.frex.Frex;
import de.pfabulist.frex.FrexMatcher;
import de.pfabulist.frex.FrexPattern;
import de.pfabulist.loracle.license.AlternativeLicense;
import de.pfabulist.loracle.license.LicenseException;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.LicenseName;
import de.pfabulist.loracle.license.SingleLicense;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public class ModifiedSingleLicense
implements LicenseID {
    private final LicenseID base;
    private final boolean orLater;
    private final List<LicenseException> exception;
    private static FrexPattern namePattern = SingleLicense.getGoodFrex().var((Enum)NamePatternVars.name).then((Frex)Frex.whitespace().zeroOrMore()).then((Frex)Frex.txt((char)'+').var((Enum)NamePatternVars.plus).zeroOrOnce()).then((Frex)Frex.whitespace().oneOrMore().then(Frex.txt((String)"WITH")).then((Frex)Frex.whitespace().oneOrMore()).then(SingleLicense.getGoodFrex().var((Enum)NamePatternVars.exception)).zeroOrOnce()).buildCaseInsensitiveFrexPattern();
    private static FrexPattern altNamePattern = Frex.any().oneOrMore().lazy().var((Enum)NamePatternVars.name).then((Frex)Frex.whitespace().zeroOrMore()).then((Frex)Frex.txt((char)'+').var((Enum)NamePatternVars.plus).zeroOrOnce()).then((Frex)Frex.whitespace().oneOrMore().then(Frex.txt((String)"WITH")).then((Frex)Frex.whitespace().oneOrMore()).then(SingleLicense.getGoodFrex().var((Enum)NamePatternVars.exception)).zeroOrOnce()).buildCaseInsensitiveFrexPattern();

    public ModifiedSingleLicense(LicenseID singleLicense, boolean orLater, Optional<LicenseException> exception) {
        this.exception = exception.map(xva$0 -> Arrays.asList(xva$0)).orElseGet(Collections::emptyList);
        this.base = singleLicense;
        this.orLater = orLater;
    }

    public static LicenseID getAlternativeOrModifiedLicense(String nameExpr) {
        FrexMatcher matcher = altNamePattern.getMatcher_ot(nameExpr);
        AlternativeLicense sli = AlternativeLicense.newStd(matcher.get_ot((Enum)NamePatternVars.name));
        boolean plus = matcher.get((Enum)NamePatternVars.plus).isPresent();
        Optional<LicenseException> ex = matcher.get((Enum)NamePatternVars.exception).map(LicenseException::newStd);
        if (plus || ex.isPresent()) {
            return new ModifiedSingleLicense(sli, plus, ex);
        }
        return sli;
    }

    public static LicenseID getSingleOrModifiedLicense(String nameExpr) {
        FrexMatcher matcher = namePattern.getMatcher_ot(nameExpr);
        SingleLicense sli = SingleLicense.newStd(matcher.get_ot((Enum)NamePatternVars.name));
        boolean plus = matcher.get((Enum)NamePatternVars.plus).isPresent();
        Optional<LicenseException> ex = matcher.get((Enum)NamePatternVars.exception).map(LicenseException::newStd);
        if (plus || ex.isPresent()) {
            return new ModifiedSingleLicense(sli, plus, ex);
        }
        return sli;
    }

    @Override
    public LicenseName getId() {
        return new LicenseName(this.base + (this.orLater ? "+" : "") + (this.exception.size() > 0 ? " with " + this.exception.get(0).getName() : ""));
    }

    @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifiedSingleLicense that = (ModifiedSingleLicense)o;
        if (this.orLater != that.orLater) {
            return false;
        }
        if (!this.base.equals(that.base)) {
            return false;
        }
        return this.exception.equals(that.exception);
    }

    public int hashCode() {
        int result = this.base.hashCode();
        result = 31 * result + (this.orLater ? 1 : 0);
        result = 31 * result + this.exception.hashCode();
        return result;
    }

    public String toString() {
        return this.getId().toString();
    }

    public Optional<LicenseException> getException() {
        return this.exception.size() > 0 ? Optional.of(this.exception.get(0)) : Optional.empty();
    }

    public String getBase() {
        return this.base.getId().toString();
    }

    public LicenseID getBaseLicense() {
        return this.base;
    }

    @Override
    public int compareTo(LicenseID o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public boolean isAlternative() {
        return this.base.isAlternative();
    }

    static enum NamePatternVars {
        name,
        plus,
        exception;

    }
}

