/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.MappedLicense;
import de.pfabulist.roast.NonnullCheck;
import de.pfabulist.roast.functiontypes.Consumer_;
import de.pfabulist.roast.functiontypes.Supplier_;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MappedSomeLicense
implements MappedLicense {
    private final LicenseID license;
    private final String reason;
    private final List<MappedSomeLicense> diffOver = new ArrayList<MappedSomeLicense>();

    public MappedSomeLicense(LicenseID licenseID, String reason) {
        this.license = licenseID;
        this.reason = reason;
        if (reason.isEmpty()) {
            throw new IllegalArgumentException("can't have a MappedLicense without reason");
        }
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public LicenseID orElseThrow(Supplier_<Exception> ex) {
        return this.license;
    }

    @Override
    public void ifPresent(Consumer_<LicenseID> con) {
        con.accept_((Object)this.license);
    }

    @Override
    public MappedSomeLicense addReason(String more) {
        if (more.isEmpty()) {
            return this;
        }
        return new MappedSomeLicense((LicenseID)NonnullCheck._nn((Object)this.license), this.reason + " && " + more);
    }

    public String toString() {
        String diff = "";
        if (!this.diffOver.isEmpty()) {
            diff = "!override!  [" + this.diffOver.stream().map(Object::toString).collect(Collectors.joining()) + "]";
        }
        return this.license + " [" + this.reason + "]" + diff;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public Optional<LicenseID> noReason() {
        return Optional.of(this.license);
    }

    @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedSomeLicense that = (MappedSomeLicense)o;
        return this.license.equals(that.license);
    }

    public int hashCode() {
        return this.license.hashCode();
    }

    public <U> U orElse(Function<LicenseID, U> f, U els) {
        if (this.isPresent()) {
            return (U)NonnullCheck._nn(f.apply((LicenseID)NonnullCheck._nn((Object)this.license)));
        }
        return els;
    }

    public void addOver(MappedSomeLicense other) {
        if (this == other) {
            return;
        }
        if (other.isPresent() && !this.equals(other)) {
            this.diffOver.add(other);
        }
        other.diffOver.forEach(over -> {
            if (!this.equals(over)) {
                this.diffOver.add((MappedSomeLicense)over);
            }
        });
    }
}

