/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.MappedEmptyLicense;
import de.pfabulist.loracle.license.MappedLicenseGroup;
import de.pfabulist.loracle.license.MappedSomeLicense;
import de.pfabulist.roast.functiontypes.Consumer_;
import de.pfabulist.roast.functiontypes.Supplier_;
import java.util.Arrays;
import java.util.Optional;

public interface MappedLicense {
    public static MappedEmptyLicense empty() {
        return new MappedEmptyLicense();
    }

    public static MappedSomeLicense of(LicenseID licenseID, String reason) {
        return new MappedSomeLicense(licenseID, reason);
    }

    public static MappedLicense of(MappedLicense one, MappedLicense two) {
        return new MappedLicenseGroup(one, two);
    }

    public static MappedLicense of(Optional<LicenseID> licenseID, String reason) {
        return licenseID.map(l -> MappedLicense.of(l, reason)).orElse(MappedLicense.empty());
    }

    public boolean isPresent();

    public LicenseID orElseThrow(Supplier_<Exception> var1);

    public void ifPresent(Consumer_<LicenseID> var1);

    public MappedLicense addReason(String var1);

    public String getReason();

    public static MappedLicense empty(String reason) {
        return new MappedEmptyLicense(reason);
    }

    public static MappedLicense decide(MappedLicense ... mls) {
        MappedLicense ret = Arrays.stream(mls).filter(MappedLicense::isPresent).findFirst().orElse(MappedLicense.empty());
        return ret;
    }

    public Optional<LicenseID> noReason();
}

