/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.LicenseIDs;
import de.pfabulist.loracle.license.LicenseName;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public class CompositeLicense
implements LicenseID {
    private final boolean orNotAnd;
    private final LicenseID left;
    private final LicenseID right;

    public CompositeLicense(boolean orNotAnd, LicenseID left, LicenseID right) {
        this.orNotAnd = orNotAnd;
        int cmp = left.compareTo(right);
        if (cmp < 0) {
            this.left = left;
            this.right = right;
        } else if (cmp > 0) {
            this.left = right;
            this.right = left;
        } else {
            throw new IllegalArgumentException("composite of the license");
        }
    }

    public LicenseID getLeft() {
        return this.left;
    }

    public LicenseID getRight() {
        return this.right;
    }

    public boolean isOr() {
        return this.orNotAnd;
    }

    public boolean isAnd() {
        return !this.orNotAnd;
    }

    @Override
    public LicenseName getId() {
        return new LicenseName(this.encapsulateOr(this.left) + (this.orNotAnd ? " or " : " and ") + this.encapsulateOr(this.right));
    }

    private String encapsulateOr(LicenseID id) {
        if (LicenseIDs.isOr(id)) {
            return "( " + id + " )";
        }
        return id.getId().toString();
    }

    @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeLicense that = (CompositeLicense)o;
        if (this.orNotAnd != that.orNotAnd) {
            return false;
        }
        if (!this.left.equals(that.left)) {
            return false;
        }
        return this.right.equals(that.right);
    }

    public int hashCode() {
        int result = this.orNotAnd ? 1 : 0;
        result = 31 * result + this.left.hashCode();
        result = 31 * result + this.right.hashCode();
        return result;
    }

    public String toString() {
        return this.getId().toString();
    }

    @Override
    public int compareTo(LicenseID o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public boolean isAlternative() {
        return this.left.isAlternative() || this.right.isAlternative();
    }
}

