package de.pfabulist.loracle.license.known;

import de.pfabulist.kleinod.frex.Frex;
import de.pfabulist.loracle.license.GoodString;

import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static de.pfabulist.loracle.license.known.LoUrl.UrlVeriables.relevant;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class LoUrl extends GoodString {

    public static Pattern urlPattern =
            Frex.or( Frex.txt( "http://" ), Frex.txt( "https://" ) ).zeroOrOnce().
                    then( Frex.txt( "www." ).zeroOrOnce() ).
                    then( Frex.any().oneOrMore().lazy().var( relevant ) ).
                    then( Frex.txt( "." ).then( Frex.alpha().oneOrMore() ).zeroOrOnce() ).
                    //then( Frex.txt( '/' )).zeroOrOnce().
                            buildCaseInsensitivePattern();

    public enum UrlVeriables {
        relevant
    }



    LoUrl( String url ) {
        super(url);
    }

    @Override
    public boolean isValid( String str ) {
        return getReleventUrlPart( str ).isPresent();
    }


    public static LoUrl newStd( String in ) {
        return new LoUrl(
                getReleventUrlPart( in ).
                        orElseThrow( () -> new IllegalArgumentException( "no relevant path part" ) ));
    }


    public static Optional<String> getReleventUrlPart( String str ) {
        String lower = str.toLowerCase( Locale.US );
        Matcher matcher = urlPattern.matcher( lower );
        if ( !matcher.matches() ) {
            return Optional.empty();
        }

        return  Optional.ofNullable( matcher.group( relevant.toString() ));
    }

}
