package de.pfabulist.loracle.license.known;

import de.pfabulist.kleinod.frex.Frex;
import de.pfabulist.loracle.license.GoodString;
import de.pfabulist.loracle.text.Normalizer;

import java.util.regex.Pattern;

import static de.pfabulist.kleinod.frex.Frex.txt;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class LoLongName extends GoodString {

    private static Pattern hasOr = Frex.or( txt( " "), txt( "(") ).then( txt( "or ") ).buildCaseInsensitivePattern();

    private LoLongName( String good ) {
        super( good );
    }

    @Override
    public boolean isValid( String str ) {
        return !hasOr.matcher( str ).find();
    }

    public static LoLongName newStd( String in ) {
        String longName = Normalizer.reduce( in );

        if( hasOr.matcher( longName ).find() ) {
            throw new IllegalArgumentException( "has on 'or' in it" );
        }

        return new LoLongName( longName );

    }


}
