package de.pfabulist.loracle.license.known;

import de.pfabulist.kleinod.frex.Frex;
import de.pfabulist.loracle.license.GoodString;

import java.util.regex.Pattern;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class LicenseDefinitionSource extends GoodString {

    public LicenseDefinitionSource( String url ) {
        super( url );
    }

    static private Pattern pat = Frex.alphaLower().buildPattern();

    @Override
    public boolean isValid( String str ) {
        return pat.matcher( str ).matches();
    }
}
