package de.pfabulist.loracle.license.known;

import de.pfabulist.kleinod.frex.Frex;
import de.pfabulist.loracle.license.AlternativeLicense;
import de.pfabulist.loracle.license.AlternativeParser;
import de.pfabulist.loracle.license.CompositeLicense;
import de.pfabulist.loracle.license.LicenseException;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.ModifiedSingleLicense;
import de.pfabulist.loracle.license.SPDXParser;
import de.pfabulist.loracle.license.SingleLicense;
import de.pfabulist.loracle.maven.Coordinates;
//import de.pfabulist.roast.collection.Map_;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;

import static de.pfabulist.kleinod.frex.Frex.txt;
import static de.pfabulist.roast.types.NonnullCheck.n_;
import static de.pfabulist.roast.types.NonnullCheck.n_or;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

@SuppressFBWarnings( { "URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD" } )
public class LOracleKnown {

    private static Pattern hasOr = Frex.or( txt( " " ), txt( "(" ) ).then( txt( "or " ) ).buildCaseInsensitivePattern();

    public Optional<ExistingLicense> getExistingSingle( SingleLicense loLicenseId ) {
        return Optional.ofNullable( singles.get( loLicenseId.toString() ) ).
                map( more -> new ExistingLicense( this, loLicenseId, more ) );
    }

    public <V,K> Optional<V> get_o( Map<K,V> map, K search ) {
        @Nullable V found =  map.get( search );
        if ( found == null ) {
            return Optional.empty();
        }

        return Optional.of( found );
    }

    public Optional<LicenseException> getExistingExclude( LicenseException exclude ) {
        if( get_o( licenseExceptions, exclude.getName() ).isPresent() ) {
            return Optional.of( exclude );
        }
        return Optional.empty();
    }

    public Optional<ExistingLicense> getExistingLicense( String str ) {

        try {
            LoLongName ll = LoLongName.newStd( str );
            @Nullable LicenseID id = longNameMapper.get( ll.toString() );
            if( id != null ) {
                Optional<ExistingLicense> ex = getExistingLicense( id );
                if ( !ex.isPresent()) {
                    throw new IllegalArgumentException( "must be there" );
                }
                return ex;
            }
        } catch( Exception e ) {}

        // todo use longtermmap directly ?
        
            Optional<ExistingLicense> ext = new SPDXParser().parse( str ).
                                                flatMap( this::getExistingLicense );
            if ( ext.isPresent()) {
                return ext;
            }

            return new AlternativeParser().parse( str ).
                           flatMap( this::getExistingLicense );

//            Optional<LicenseID> li = new AlternativeParser().parse( str );
//            if( li.isPresent() ) {
//                Optional<ExistingLicense> limore = getExistingLicense( li.get() );
//                if( limore.isPresent() ) {
//                    return limore;
//                }
//            }
//
//            return Optional.empty();
   //           return Optional.ofNullable( longNameMapper.get( alternative.toString() )).
//                    map( id ->
//                         {
//                                                                                               if ( id.isSingle() ) {
//                                                                                                   new ExistingLicense( this, singles., id )
//                                                                                               } );
//        } catch ( Exception e ) {
//            return Optional.empty();
//        }

//        LoLongName alternative = LoLongName.newStd( str );
//        @Nullable LicenseID altli = longNameMapper.get( alternative.toString() );
//
//        if( altli != null ) {
//            if( altli.isSingle() ) {
//                More more = Map_.r_( singles ).get_ot( altli.toString() );
//                return Optional.of( new ExistingLicense( this, altli, more ) );
//            }
//
//            More more = Map_.r_( composites ).get_ot( altli.toString() );
//            return Optional.of( new ExistingLicense( this, altli, more ) );
//            // complicated
//        }
//
//        // todo alternative ??
//        // not yet
//        // fuzzyparser
//
//        return Optional.empty();
   }

    public Optional<ExistingLicense> getExistingLicense( LicenseID lid ) {
        if( lid instanceof SingleLicense ) {
            return getExistingSingle( (SingleLicense) lid );
        }

        if( lid instanceof ModifiedSingleLicense ) {
            return getExistingModified( (ModifiedSingleLicense) lid );
        }

        if( lid instanceof CompositeLicense ) {
            return getExistingComposite( (CompositeLicense) lid );
        }

        if( lid instanceof AlternativeLicense ) {
            return getExistingAlternative( (AlternativeLicense) lid );
        }

        throw new IllegalStateException( "unknown type of license " + lid.getClass() );
    }

    private Optional<ExistingLicense> getExistingAlternative( AlternativeLicense lid ) {
//        // previously known
//        LoLongName alternative = LoLongName.newStd( lid.toString() );
//
//        return Optional.ofNullable(
//                longNameMapper.get( alternative.toString() ) ).
//                flatMap( this::getExistingLicense ) ;
//
        return longNameMapperGet( lid ).flatMap( this::getExistingLicense );
//
//
//        if( altli != null ) {
//            if( altli.isSingle() ) {
//                More more = Map_.r_( singles ).get_ot( altli.toString() );
//                return Optional.of( new ExistingLicense( this, altli, more ) );
//            }
//
//            More more = Map_.r_( composites ).get_ot( altli.toString() );
//            return Optional.of( new ExistingLicense( this, altli, more ) );
//            // complicated
//        }
//
//        // not known shortcut
//        return Optional.empty();
//
    }

    // must be an existent li
    private Optional<LicenseID> longNameMapperGet( LicenseID li ) {
        return Optional.ofNullable( longNameMapper.get( LoLongName.newStd( li.toString() ).toString() ));
    }

    private void longNameMapperPut( LicenseID li, LicenseID to ) {

        longNameMapperGet( li ).ifPresent( r -> { throw new IllegalArgumentException( "already in long names: " + li );} );
        if ( to.isAlternative()) {
            throw new IllegalArgumentException( "dont map it to a alternative: " + to );
        }

        longNameMapper.put( LoLongName.newStd( li.toString() ).toString(), to);
    }

    private Optional<ExistingLicense> getExistingComposite( CompositeLicense license ) {
        // previously known
        @Nullable More more = composites.get( license.getId().toString() );
        if( more != null ) {
            return Optional.of( new ExistingLicense( this, license, more ));
        }

        Optional<LicenseID> alt = longNameMapperGet( license );
        if ( alt.isPresent() ) {
            return getExistingLicense( alt.get() );
        }

        Optional<ExistingLicense> leftex = getExistingLicense( license.getLeft());
        Optional<ExistingLicense> rightex = getExistingLicense( license.getRight());


        if ( !leftex.isPresent() ||
                !rightex.isPresent()) {
            return Optional.empty();
        }

        CompositeLicense coex = new CompositeLicense( license.isOr(), leftex.get().getLicenseId(), rightex.get().getLicenseId() );

        if ( !coex.equals( license )) {
            Optional<ExistingLicense> ret = getExistingLicense( coex );
            ret.ifPresent( el -> longNameMapperPut( license, el.getLicenseId() ) );
            return ret;
        }

        more = new More( new LicenseDefinitionSource( "c" ) ); // todo calc this kind
        
        composites.put( license.toString(), more );
        longNameMapperPut( license, license ); // real name ?

        return Optional.of( new ExistingLicense( this, license, more ) );
    }

//    private void addKnownCompositives( CompositeLicense compo ) {
//        ExistingLicense left = getExistingLicense( compo.getLeft()).orElseThrow( () -> new IllegalArgumentException( "not known " + compo.getLeft()));
//        ExistingLicense right = getExistingLicense( compo.getRight()).orElseThrow( () -> new IllegalArgumentException( "not known " + compo.getRight()));  // todo list
//
//        LicenseDefinitionSource src = new LicenseDefinitionSource(
//                left.getMore().attributes.isSPDX() && right.getMore().attributes.isSPDX() ? "s"  : "c" );
//
//        More more = new More( src );
//        composites.put( compo.getId()., more );
//
//        longNameMapper.put( co )
//
//    }

    private Optional<ExistingLicense> getExistingModified( ModifiedSingleLicense modi ) {
        // previously known
        @Nullable More more = composites.get( modi.getId().toString() );
        if( more != null ) {
            return Optional.of( new ExistingLicense( this, modi, more ));
        }

        Optional<LicenseID> alt = longNameMapperGet( modi );
        if ( alt.isPresent() ) {
            return getExistingLicense( alt.get() );
        }

        if ( modi.isAlternative()) {
            return Optional.empty();
        }

        // possible
        LicenseID base = modi.getBaseLicense();

        Optional<ExistingLicense> existingBase = getExistingLicense( base );

        if( !existingBase.isPresent() ) {
            return Optional.empty();
        }

        Optional<LicenseException> ex = modi.getException();
        if ( ex.isPresent() ) {
            if ( !getExistingExclude( ex.get() ).isPresent()) {
                return Optional.empty(); // exception not in db
            }
        }
 //        modi.getException().
//                ifPresent( e -> {
//                    if( !getExistingExclude( e ).isPresent() ) {
//                        throw new IllegalStateException( "modified license on non existing single license " + modi );
//                    }
//                } );

        // todo with alt src
        // todo
        // def src equality check
        // todo
        // long name

        more = new More( existingBase.get().getMore().getDefinitionSource() );
        composites.put( modi.getId().toString(), more );
        longNameMapperPut( modi, modi ); // real name ?

        return Optional.of( new ExistingLicense( this, modi, more ) );
    }

    @SuppressFBWarnings( "URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD" )
    public static class More {
        public LicenseAttributes attributes;
        public List<String> urls = new ArrayList<>();
        private List<String> longNames = new ArrayList<>();    // list of alternative names
        // only in form of alternative names
        public List<Coordinates> specific = new ArrayList<>();
        public Set<String> couldbeName = new HashSet<>();
        public Set<String> couldbeUrl = new HashSet<>();

        public More( LicenseDefinitionSource src ) {
            attributes = new LicenseAttributes();
            attributes.setSource( src );
        }

        public void addLongName( LoLongName name ) {
            if( !longNames.contains( name.toString() ) ) {
                longNames.add( name.toString() );
            }
        }

        public LicenseDefinitionSource getDefinitionSource() {
            return attributes.getDefinitionSource();
        }

        public List<String> getLongNames() {
            return longNames;
        }
    }

    // the list of single licenses
    // stored in a treemap, so in json you get an alphabetically ordered list
    private Map<String, More> singles = new TreeMap<>( String::compareTo );
    //new HashMap<>();
    private Map<String, Boolean> licenseExceptions = new TreeMap<>( String::compareTo );
    private Map<String, More> composites = new TreeMap<>( String::compareTo );
    private List<String> tooSimpleLongNames = new ArrayList<>();    // ?

    // speed up
    private transient Map<String, LicenseID> longNameMapper = new HashMap<>();

    public boolean hasSingleLicense( SingleLicense lic ) {
        return singles.containsKey( lic.toString() );
        //return Optional.ofNullable( singles.get( lic.toString() );
    }

//    public Optional<String> whyIsBadLongName( String reduced ) {
//        try {
//            throwIfBadLongName( reduced );
//        } catch( IllegalArgumentException e ) {
//            return Optional.of( e.getMessage());
//        }
//
//        return Optional.empty();
//
//    }
//
//    public void throwIfBadLongName( String reduced ) {
//            String longName = Normalizer.reduce( reduced );
//
//            if( hasOr.matcher( longName ).find() ) {
//                throw new IllegalArgumentException( "has on 'or' in it" );
//            }
//
//            singles.forEach( ( license, more ) -> {
//                more.longNames.forEach( ln -> {
//                    if( ln.equals( longName ) ) {
//                        throw new IllegalArgumentException( "old long name: " + ln + "   (" + license + ")");
//                    }
//                } );
//            } );
//
//    }

//    public void throwIfBadLongName( SingleLicense id, String reduced ) {
//        String longName = Normalizer.reduce( reduced );
//
//        if( hasOr.matcher( longName ).find() ) {
//            throw new IllegalArgumentException( "has on 'or' in it" );
//        }
//
//        singles.forEach( ( license, more ) -> {
//            if ( !license.endsWith( id.getId() )) {
//                more.longNames.forEach( ln -> {
//                    if( ln.equals( longName ) ) {
//                        throw new IllegalArgumentException( "old long name " + ln );
//                    }
//                } );
//            }
//        } );
//
//    }

    public boolean isUsed( SingleLicense id, LoLongName name ) {
        try {
            singles.forEach( ( license, more ) -> {
                if( !id.toString().equals( license ) ) {
                    more.longNames.forEach( ln -> {
                        if( ln.equals( name.toString() ) ) {
                            throw new IllegalArgumentException( "old long name " + ln );
                        }
                    } );
                }
            } );
        } catch( IllegalArgumentException e ) {
            return false;
        }

        return true;

    }

    public ExistingLicense addSingle( SingleLicense li, LicenseDefinitionSource src ) {
        if( singles.get( li.toString() ) != null ) {
            throw new IllegalArgumentException( "old single license " + li );
        }

        // todo alternative name ?
        getExistingLicense( li.toString() ).
                ifPresent( c -> {
                    throw new IllegalArgumentException( "exists already, old: " + c );
                } );
        //LoLongName name = LoLongName.newStd( li.toString() );
        //throwIfBadLongName( li.toString() );

        More more = new More( src );         // todo
        more.longNames.add( LoLongName.newStd( li.toString() ).toString() );
        singles.put( li.toString(), more );
        //return more;

        longNameMapperPut( li, li );

        return new ExistingLicense( this, li, more );
    }

//    public void addLongName( SingleLicense id, String str ) {
//        String reduced = Normalizer.reduce( str );
//        throwIfBadLongName( id, reduced );
//
//        @Nullable More more = singles.get( id.toString() );
//
//        if ( more == null ) {
//            throw new IllegalArgumentException( "not a single license " + id );
//        }
//
//        more.longNames.add( reduced );
//
//    }

    public void addShortCut( LoLongName name, ExistingLicense li ) {
        if ( longNameMapper.get( name.toString() ) != null ) {
            throw new IllegalArgumentException( "is already a short cut" );
        }
        this.longNameMapper.put( name.toString(), li.getLicenseId() );
    }

//    public void addLongName( LicenseID id, LoLongName str ) {
//
//        getExistingLicense( str.toString() ).
//                ifPresent( l -> { throw new  IllegalArgumentException( "already in db " + str );});
//
////        String reduced = Normalizer.reduce( str );
////        throwIfBadLongName( id, reduced );
////
//        @Nullable More more = singles.get( id.toString() );
//
//        if ( more == null ) {
//            throw new IllegalArgumentException( "not a single license " + id );
//        }
//
//        more.longNames.add( str.toString() );
//
//    }

    public void addUrl( SingleLicense id, String url ) {
        @Nullable More more = singles.get( id.toString() );

        if( more == null ) {
            throw new IllegalArgumentException( "not a single license " + id );
        }

        more.urls.add( url );
    }

    public void addException( LicenseException ex ) {
        licenseExceptions.put( ex.toString(), true );
    }

    public Stream<Map.Entry<String, More>> getSingleStream() {
        return singles.entrySet().stream();
    }

    public LicenseAttributes getAttributes( LicenseID id ) {

        Optional<ExistingLicense> ex = getExistingLicense( id );
        if ( !ex.isPresent()) {

            throw new IllegalArgumentException( "not a single license " + id );
        }

        return ex.get().getMore().attributes;
    }

    public LOracleKnown speedUp() {
        if( !longNameMapper.isEmpty() ) {
            throw new IllegalStateException( "can only be called after json construction" );
        }

        singles.forEach( ( name, more ) -> {
                             LicenseID lid = new SingleLicense( name );
                             // todo more.urls.forEach( u -> urls.put( u, lid ) );
                             more.longNames.forEach( l -> longNameMapper.putIfAbsent( l, lid ) );
                             // todo
//                             more.specific.forEach( coo -> coordinatesMap.putIfAbsent( coo, lid ) );
//                             more.couldbeName.forEach( n -> {
//                                 couldbeNames.putIfAbsent( n, new HashSet<>() );
//                                 _nn( couldbeNames.get( n ) ).add( lid );
//                             } );
//                             more.couldbeUrl.forEach( n -> {
//                                 couldbeUrls.putIfAbsent( n, new HashSet<>() );
//                                 _nn( couldbeUrls.get( n ) ).add( lid );
//                             } );
                         }
        );

        //System.out.println( "    composites" );

        composites.forEach( ( name, more ) -> {

                                LicenseID lid = new SPDXParser().parse_ot( name );
                                // more.urls.forEach( u -> urls.put( u, lid ) );
                                more.longNames.forEach( l -> longNameMapper.putIfAbsent( l, lid ) );
//                                more.specific.forEach( coo -> coordinatesMap.putIfAbsent( coo, lid ) );
//                                more.couldbeName.forEach( n -> {
//                                    couldbeNames.putIfAbsent( n, new HashSet<>() );
//                                    _nn( couldbeNames.get( n ) ).add( lid );
//                                } );
//                                more.couldbeUrl.forEach( n -> {
//                                    couldbeUrls.putIfAbsent( n, new HashSet<>() );
//                                    _nn( couldbeUrls.get( n ) ).add( lid );
//                                } );
                            }
        );

        return this;
    }

}
