package de.pfabulist.loracle.license.known;

import de.pfabulist.loracle.license.LicenseException;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.MappedLicense;
import de.pfabulist.loracle.license.SPDXParser;
import de.pfabulist.loracle.license.SingleLicense;

import java.util.Locale;
import java.util.Optional;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class LOracle2 {


    public static Optional<SingleLicense> getExistingSingle( LOracleKnown ldata, String name ) {
        String lower = name.trim().toLowerCase( Locale.US );
        SingleLicense single = new SingleLicense( lower );
        return ldata.getExistingSingle( single ).map( m -> single );
    }

    public static LicenseException getExceptionOrThrow( LOracleKnown ldata, String ex ) {
        String lower = ex.trim().toLowerCase( Locale.US );
        LicenseException exclude = new LicenseException( lower );
        return ldata.getExistingExclude( exclude ).orElseThrow( () -> new IllegalArgumentException( "no such exception: " + ex ));
    }


    public static MappedLicense getExistingSingleByName( LOracleKnown ldata, String name ) {

        if( name.isEmpty() ) {
            return MappedLicense.empty( "no name" );
        }

        try {
            LicenseID sid = new SPDXParser().parse_ot( name );
            if ( getExistingSingle( ldata, sid.toString() ).isPresent() ) {
                return MappedLicense.of( sid, "by parsed name: " + name );
            }
        } catch( Exception e ) {
            // not found
        }


        return MappedLicense.empty();
    }
//
//        boolean plus = false;
//        String base = name;
//        Matcher matcher = orLater.matcher( name );
//        if( matcher.matches() ) {
//            base = _nn( matcher.group( "base" ) );
//            plus = true;
//        }
//
//        Optional<LicenseID> ret = Optional.ofNullable( longNameMapper.get( normalizer.reduce( base ) ) );
//
//        if( ret.isPresent() ) {
//            if( plus ) {
//                if( ret.get() instanceof SingleLicense ) {
//                    return MappedLicense.of( getOrLater( (SingleLicense) _nn( ret.get() ), true, Optional.empty() ), "by normalized name and 'or later': " + name );
//                } else {
//                    // or later with a composite license is strange
//                    return MappedLicense.empty( " or later with composite (?)" );
//                }
//            }
//            return MappedLicense.of( ret, "by normalized name: " + name );
//        }
//
//        try {
//            return MappedLicense.of( new FuzzyParser( this ).parse( name ), "by fuzzy parsing name: " + name );
//        } catch( Exception e ) {
//            return MappedLicense.empty( "unknown name" );
//        }
//    }

}
