package de.pfabulist.loracle.license.known;

import de.pfabulist.loracle.license.LicenseID;

import java.util.Optional;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class ExistingLicense {

    private final LOracleKnown all;
    private final LicenseID license;
    private final LOracleKnown.More data;

    public ExistingLicense( LOracleKnown all, LicenseID license, LOracleKnown.More data ) {
        this.all = all;
        this.license = license;
        this.data = data;
    }

    public void addAlternativeName( LoLongName alternativeName ) {
        Optional<ExistingLicense> before = all.getExistingLicense( alternativeName.toString());
        if ( before.isPresent() ) {
            if ( before.get().getLicenseId().equals( license )) {
                return; // shown done
            }
            throw new  IllegalArgumentException( "already in db " + alternativeName );
        }
//                all.getExistingLicense(alternativeName.toString()  ).
//                ifPresent( l -> {
//                    if ( !l.equals( license) ) {
//                        throw new  IllegalArgumentException( "already in db " + alternativeName );
//                    }});
//        
        data.addLongName( alternativeName );
        all.addShortCut( alternativeName, this );

        // logic with names ending with 'only'
        if( alternativeName.toString().endsWith( "only" ) ) {
            try {
                addAlternativeName( LoLongName.newStd( alternativeName.toString().replace( "only", "" ) ) );
            } catch ( Exception e ) {
                // worked with 'only' already
            }
        }

 }

    public LOracleKnown.More getMore() {
        return data;
    }

    public LicenseID getLicenseId() {
        return license;
    }
}
