package de.pfabulist.loracle.license;

import de.pfabulist.roast.types.functiontypes.Consumer_;
import de.pfabulist.roast.types.functiontypes.Supplier_;
import de.pfabulist.roast.unchecked.Unchecked;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

import static de.pfabulist.roast.types.NonnullCheck.n_;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class MappedSomeLicense implements MappedLicense {
    private final LicenseID license;
    private final String reason;
    private final List<MappedSomeLicense> diffOver = new ArrayList<>();

//    private MappedSomeLicense() {
//        license = null;
//        reason = "";
//    }

    public MappedSomeLicense( LicenseID licenseID, String reason ) {
        this.license = licenseID;
        this.reason = reason;

        if( reason.isEmpty() ) {
            throw new IllegalArgumentException( "can't have a MappedLicense without reason" );
        }
    }

//    public MappedSomeLicense( String reason ) {
//        this.license = null;
//        this.reason = reason;
//        if( reason.isEmpty() ) {
//            throw new IllegalArgumentException( "can't have a MappedLicense without reason" );
//        }
//    }



    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public LicenseID orElseThrow( Supplier_<Exception> ex ) {
        return license;
    }

    @Override
    public void ifPresent( Consumer_<LicenseID> con ) {
            con.accept_( license );
    }

    @Override
    public MappedSomeLicense addReason( String more ) {
        if( more.isEmpty() ) {
            return this;
        }
        return new MappedSomeLicense( n_( license ), reason + " && " + more );
    }

    @Override
    public String toString() {
            String diff = "";
            if ( !diffOver.isEmpty()) {
                diff = "!override! " + " [" + diffOver.stream().map( Object::toString ).collect( Collectors.joining() ) + "]";
            }
            return license  + " [" + reason + "]" + diff;
    }

    @Override
    public String getReason() {
        return reason;
    }

    @Override
    public Optional<LicenseID> noReason() {
        return Optional.of( license );
    }

    @Override
    @SuppressFBWarnings( "NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION" )
    public boolean equals( @Nullable Object o ) {
        if( this == o ) {
            return true;
        }
        if( o == null || getClass() != o.getClass() ) {
            return false;
        }

        MappedSomeLicense that = (MappedSomeLicense) o;

        return license.equals( that.license );

    }

    @Override
    public int hashCode() {
        return license.hashCode();
    }

    public <U> U orElse( Function<LicenseID, U> f, U els ) {
        if( isPresent() ) {
            return n_( f.apply( n_( license ) ) );
        }

        return els;
    }


    public void addOver( MappedSomeLicense other ) {

        if ( this == other ) {
            return;
        }

        if( other.isPresent() && !equals( other ) ) {
            diffOver.add( other );
        }

        other.diffOver.forEach( over -> {
            if ( !equals( over )) {
                diffOver.add( over );
            }
        } );
    }

    // todo
//    public void addOverFrom( MappedSomeLicense other ) {
//        other.diffOver.forEach( over -> {
//            if ( equals( over )) {
//                diffOver.add( over );
//            }
//        } );
//    }


}
