package de.pfabulist.loracle.license;

import de.pfabulist.roast.types.functiontypes.Consumer_;
import de.pfabulist.roast.types.functiontypes.Supplier_;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class MappedLicenseGroup implements MappedLicense {
    private List<MappedLicense> group;

    public MappedLicenseGroup( MappedLicense ... group ) {
        this.group = Arrays.asList( group );
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public LicenseID orElseThrow( Supplier_<Exception> ex ) {
        return group.get(0).orElseThrow( ex );
    }

    @Override
    public void ifPresent( Consumer_<LicenseID> con ) {

    }

    @Override
    public MappedLicense addReason( String more ) {

        throw new IllegalArgumentException( "hmm" );
    }

    @Override
    public String getReason() {
        return group.parallelStream().map( MappedLicense::getReason ).collect( Collectors.joining( ", ") );
    }

    @Override
    public Optional<LicenseID> noReason() {
        return Optional.empty();
    }
}
