package de.pfabulist.loracle.license;

import de.pfabulist.roast.types.functiontypes.Consumer_;
import de.pfabulist.roast.types.functiontypes.Supplier_;

import java.util.Arrays;
import java.util.Optional;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public interface MappedLicense {

    static MappedEmptyLicense empty() {
        return new MappedEmptyLicense();
    }
    static MappedSomeLicense of( LicenseID licenseID, String reason ) {
        return new MappedSomeLicense( licenseID, reason );
    }
    static MappedLicense of( MappedLicense one, MappedLicense two ) {
        return new MappedLicenseGroup( one, two );
    }

    static MappedLicense of( Optional<LicenseID> licenseID, String reason ) {
        return licenseID.map( l -> (MappedLicense)of( l, reason ) ).orElse( MappedLicense.empty() );
    }


    boolean isPresent();

    LicenseID orElseThrow( Supplier_<Exception> ex );

    void ifPresent( Consumer_<LicenseID> con );

    MappedLicense addReason( String more );

    String getReason();

    static MappedLicense empty( String reason ) {
        return new MappedEmptyLicense( reason );
    }

    static MappedLicense decide( MappedLicense... mls ) {
        MappedLicense ret = Arrays.stream( mls )
                .filter( MappedLicense::isPresent )
                .findFirst()
                .orElse( MappedLicense.empty() );

        // todo
        //Arrays.stream( mls ).forEach( ret::addOver );

        return ret;
    }

    Optional<LicenseID> noReason();
}
