package de.pfabulist.loracle.license;

import de.pfabulist.roast.types.functiontypes.Consumer_;
import de.pfabulist.roast.types.functiontypes.Supplier_;
import de.pfabulist.roast.unchecked.Unchecked;

import java.util.Optional;


/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class MappedEmptyLicense implements MappedLicense {

    private String reason = "";


    public MappedEmptyLicense() {
    }

    public MappedEmptyLicense( String reason ) {
        this.reason = reason;
    }

    @Override
    public MappedLicense addReason( String more ) {
        if( more.isEmpty() ) {
            return this;
        }

        return new MappedEmptyLicense( reason + " && " + more );
    }

    @Override
    public String getReason() {
        return reason;
    }

    @Override
    public Optional<LicenseID> noReason() {
        return Optional.empty();
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public LicenseID orElseThrow( Supplier_<Exception> ex ) {
        throw Unchecked.u( ex.get_() );
    }

    @Override
    public void ifPresent( Consumer_<LicenseID> con ) {
    }

    @Override
    public String toString() {
        return "<->";
    }

    @Override
    public boolean equals( Object o ) {
        if( this == o ) return true;
        return o != null && getClass() == o.getClass();
    }

    @Override
    public int hashCode() {
        return 42;
    }
}
