package de.pfabulist.loracle.license;

import de.pfabulist.kleinod.frex.Frex;

import java.util.regex.Pattern;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class LicenseName extends GoodString {

    public LicenseName( String name ) {
        super( name );
    }

    @Override
    public boolean isValid( String str ) {
        return pat.matcher( str ).matches();
    }

    private static Pattern pat =
            Frex.or(
                    Frex.alphaLower(),
                    Frex.number(),
                    Frex.txt( '-' ),
                    Frex.txt( ' ' ),
                    Frex.txt( '+' ),
                    Frex.txt( '.' ),
                    Frex.txt( '(' ),
                    Frex.txt( ')' ) ).oneOrMore().buildPattern();

    // () really
}
