package de.pfabulist.loracle.license;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

// instead of pushing Strings use a special GoodString class
// just test once whether it has valid format
// it is non changeable as is Strings
public abstract class GoodString {

    final String good;

    public GoodString( String url ) {
        if ( !isValid( url )) {
            throw new IllegalArgumentException( "not in valid form: " + url);
        }
        this.good = url;
    }

    abstract public boolean isValid( String str );

    @Override
    public boolean equals( Object o ) {
        if( this == o ) return true;
        if( o == null || getClass() != o.getClass() ) return false;

        GoodString that = (GoodString) o;

        return good.equals( that.good );
    }

    @Override
    public int hashCode() {
        return good.hashCode();
    }

    @Override
    public String toString() {
        return good;
    }


}
