package de.pfabulist.loracle.license;

import de.pfabulist.kleinod.frex.Frex;

import java.util.Locale;

import static de.pfabulist.kleinod.frex.Frex.txt;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

// a alternative name of a single license
// and, or will be a composite
// under known it can only be in long names
public class AlternativeLicense implements LicenseID {

    static Frex goodFrex =
            Frex.or( Frex.alphaLower(), Frex.number() ).
                    then( Frex.or( Frex.alphaLower(),
                                   Frex.number(),
                                   txt( '-' ),
                                   txt( '.' ),
                                   txt( ' ')).
                            zeroOrMore() );

    private LicenseName name;

    public AlternativeLicense( String name ) {
        this.name = new LicenseName( name );
    }

    @Override
    public LicenseName getId() {
        return name;
    }

    @Override
    public int compareTo( LicenseID o ) {
        return toString().compareTo( o.toString() );
    }

    public static AlternativeLicense newStd( String str ) {

        return new AlternativeLicense( str.toLowerCase( Locale.US ) );
    }

    @Override
    public String toString() {
        return name.toString();
    }


}
