package de.pfabulist.loracle.custom;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class CustomCoordinates {

    private final String coordinates;
    private final String url;
    private final String license;

    private CustomCoordinates( String coordinates, String url, String license ) {
        this.coordinates = coordinates;
        this.url = url;
        this.license = license;
    }

    public static CustomCoordinates byUrl( String coordinates, String url ) {
        return new CustomCoordinates( coordinates, url, "" );
    }

    public static CustomCoordinates byLicense( String coordinates, String license ) {
        return new CustomCoordinates( coordinates, "", license );
    }

    public String getCoordinates() {
        return coordinates;
    }

    public String getUrl() {
        return url;
    }

    public String getLicense() {
        return license;
    }


}
