/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.spi;

import com.esotericsoftware.minlog.Log;
import de.pfabulist.loracle.custom.LoracleCustom;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class CustomService {
    private static Optional<CustomService> service = Optional.empty();
    private final ServiceLoader<LoracleCustom> loader;
    private Optional<List<LoracleCustom>> all = Optional.empty();

    private CustomService() {
        this.loader = ServiceLoader.load(LoracleCustom.class);
    }

    public static synchronized CustomService getInstance() {
        if (!service.isPresent()) {
            service = Optional.of(new CustomService());
        }
        return service.get();
    }

    public synchronized List<LoracleCustom> getAll() {
        if (!this.all.isPresent()) {
            ArrayList<Object> list = new ArrayList<Object>();
            try {
                Iterator<LoracleCustom> providers = this.loader.iterator();
                while (providers.hasNext()) {
                    list.add(NonnullCheck._nn((Object)providers.next()));
                }
            }
            catch (ServiceConfigurationError serviceError) {
                Log.warn((String)serviceError.getMessage());
                return Collections.emptyList();
            }
            this.all = Optional.of(list);
        }
        return (List)NonnullCheck._nn(this.all.get());
    }
}

