/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.mojo;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import de.pfabulist.loracle.Utils;
import de.pfabulist.loracle.license.And;
import de.pfabulist.loracle.license.ContentToLicense;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.Coordinates2License;
import de.pfabulist.loracle.license.Decider;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.license.LicenseFromText;
import de.pfabulist.loracle.license.MappedLicense;
import de.pfabulist.loracle.mojo.Downloader;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.loracle.mojo.Url2License;
import de.pfabulist.loracle.mojo.UrlToLicense;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import java.util.List;
import java.util.Optional;

public class LicenseIntelligence {
    private final LOracle lOracle;
    private final Findings log;
    private final UrlToLicense urlToLicense;

    public LicenseIntelligence(LOracle lOracle, Findings log) {
        this.lOracle = lOracle;
        this.log = log;
        this.urlToLicense = new UrlToLicense(lOracle, log);
    }

    public void compute(Coordinates coordinates, Coordinates2License.LiCo liCo) {
        MappedLicense sum;
        MappedLicense t5;
        String u;
        MappedLicense t4;
        MappedLicense t3;
        MappedLicense t2;
        MappedLicense byCoo = this.lOracle.getByCoordinates(coordinates);
        liCo.setByCoordinates(byCoo);
        MappedLicense byPom = liCo.getMavenLicenses().stream().map(this::mavenLicenseToLicense).reduce(MappedLicense.empty(), (a, b) -> new And(this.lOracle, this.log, true).and((MappedLicense)a, (MappedLicense)b));
        liCo.setPomLicense(byPom);
        LicenseFromText lft = new LicenseFromText(this.lOracle);
        MappedLicense t1 = lft.getLicense(liCo.getLicenseTxt());
        if (t1.isPresent()) {
            liCo.setLicenseTxtLicense(t1);
        }
        if ((t2 = lft.getLicense(liCo.getPomHeader())).isPresent()) {
            liCo.setPomHeaderLicense(t2);
        }
        if ((t3 = lft.getLicense(liCo.getHeaderTxt())).isPresent()) {
            liCo.setHeaderLicense(t3);
        }
        if ((t4 = lft.getLicense(liCo.getNotice())).isPresent()) {
            liCo.setNoticeLicense(t4);
        }
        String txt = "";
        if (liCo.getMavenLicenses().size() > 0 && !(u = ((Coordinates2License.MLicense)NonnullCheck._nn(((List)NonnullCheck._nn(liCo.getMavenLicenses())).get(0))).getUrl()).isEmpty()) {
            new Downloader(this.log, new Url2License(), this.lOracle).download(u);
            txt = new Downloader(this.log, new Url2License(), this.lOracle).get(u);
        }
        if ((t5 = lft.getLicense(txt)).isPresent()) {
            this.log.debug("[woo] " + coordinates + " -> " + t5);
            liCo.setLicenseTxtLicense(t5);
        }
        if ((sum = new Decider().decide(byCoo, byPom, t1, t2, t3, t4, t5)).isPresent()) {
            liCo.setLicense(sum);
            return;
        }
        this.log.debug("searching in in content for " + coordinates);
        MappedLicense byPomHeader = new ContentToLicense(this.lOracle, "by pom header", this.log, true).findLicenses(liCo.getPomHeader());
        liCo.setPomHeaderLicense(byPomHeader);
        MappedLicense byLicenseTxt = new ContentToLicense(this.lOracle, "by license file", this.log, true).findLicenses(liCo.getLicenseTxt());
        liCo.setLicenseTxtLicense(byLicenseTxt);
        MappedLicense byHeader = new ContentToLicense(this.lOracle, "by file header", this.log, true).findLicenses(liCo.getHeaderTxt());
        liCo.setHeaderLicense(byHeader);
        MappedLicense byNotice = new ContentToLicense(this.lOracle, "by notice", this.log, true).findLicenses(liCo.getNotice());
        liCo.setNoticeLicense(byNotice);
        sum = new Decider().decide(byCoo, byPom, byPomHeader, byLicenseTxt, byHeader, byNotice);
        liCo.setLicense(sum);
        this.log.debug("done found?: " + sum.toString());
    }

    public MappedLicense mavenLicenseToLicense(Coordinates2License.MLicense mavenLicense) {
        Optional<String> name = Optional.of(mavenLicense.getName());
        MappedLicense byName = name.map(this.lOracle::getByName).orElse(MappedLicense.empty());
        if (name.isPresent() && !byName.isPresent()) {
            byName = this.getCustomLicenseByName((String)NonnullCheck._nn((Object)name.get()));
        }
        Optional<String> url = Optional.of(mavenLicense.getUrl());
        MappedLicense byUrl = url.map(this.urlToLicense::getLicense).orElse(MappedLicense.empty());
        MappedLicense byUrlText = url.map(u -> {
            if (u.isEmpty()) {
                return MappedLicense.empty();
            }
            new Downloader(this.log, new Url2License(), this.lOracle).download((String)u);
            String txt = new Downloader(this.log, new Url2License(), this.lOracle).get((String)u);
            if (txt.isEmpty()) {
                return MappedLicense.empty();
            }
            LicenseFromText lft = new LicenseFromText(this.lOracle);
            MappedLicense ret = lft.getLicense(txt);
            if (ret.isPresent()) {
                this.log.debug("[full] " + u);
            }
            return ret;
        }).orElse(MappedLicense.empty());
        MappedLicense byComments = new ContentToLicense(this.lOracle, "comments", this.log, true).findLicenses(mavenLicense.getComment());
        mavenLicense.setByName(byName);
        if (byUrlText.isPresent()) {
            mavenLicense.setByUrl(byUrlText);
        } else {
            mavenLicense.setByUrl(byUrl);
        }
        mavenLicense.setByComment(byComments);
        return new Decider().decide(byUrlText, byName, byUrl, byComments);
    }

    private MappedLicense getCustomLicenseByName(String name) {
        String licensep = Utils.getResourceAsString("/de/pfabulist/loracle/licenses/" + name + ".json");
        if (licensep.isEmpty()) {
            this.log.debug("no such license: " + name);
            return MappedLicense.empty();
        }
        try {
            LOracle.More more = (LOracle.More)new Gson().fromJson(licensep, LOracle.More.class);
            MappedLicense ret = MappedLicense.of(this.lOracle.newSingle(name, more), "by new addon license");
            this.log.info("added new license " + name);
            return ret;
        }
        catch (JsonSyntaxException more) {
        }
        catch (IllegalArgumentException e) {
            this.log.warn("new license in extension is not new (ignored) " + name);
        }
        return MappedLicense.empty();
    }
}

