/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.mojo;

import de.pfabulist.loracle.attribution.CopyrightHolder;
import de.pfabulist.loracle.attribution.GetHolder;
import de.pfabulist.loracle.attribution.JarAccess;
import de.pfabulist.loracle.attribution.SrcAccess;
import de.pfabulist.loracle.buildup.JSONStartup;
import de.pfabulist.loracle.license.ContentToLicense;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.Coordinates2License;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.mojo.Downloader;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.loracle.mojo.LicenseDeclaration;
import de.pfabulist.loracle.mojo.LicenseIntelligence;
import de.pfabulist.loracle.mojo.MavenLicenseOracle;
import de.pfabulist.loracle.mojo.Url2License;
import de.pfabulist.loracle.mojo.UrlDeclaration;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import de.pfabulist.unchecked.NullCheck;
import de.pfabulist.unchecked.Unchecked;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Build;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class LicenseCheckMojo {
    private final Findings log;
    private final MavenLicenseOracle mlo;
    private final LOracle lOracle;
    private final MavenProject mavenProject;
    private final DependencyGraphBuilder dependencyGraphBuilder;
    private final boolean andIsOr;
    private final Url2License urlToLicense;
    private Optional<Coordinates> self = Optional.empty();
    private final Coordinates2License coordinates2License;

    public LicenseCheckMojo(Findings log, Path localRepo, MavenProject project, DependencyGraphBuilder dependencyGraphBuilder, boolean andIsOr) {
        this.log = log;
        this.dependencyGraphBuilder = dependencyGraphBuilder;
        this.mlo = new MavenLicenseOracle(log, localRepo);
        this.lOracle = JSONStartup.start().spread();
        this.mavenProject = project;
        this.andIsOr = andIsOr;
        log.info("---------------------------------------");
        log.info("      loracle license check            ");
        log.info("---------------------------------------");
        this.coordinates2License = JSONStartup.previous(andIsOr);
        this.coordinates2License.setLog(log);
        this.urlToLicense = JSONStartup.urls();
    }

    public void config(List<LicenseDeclaration> licenseDeclarations, List<UrlDeclaration> urlDeclarations, int allowUrlsCheckedDaysBefore) {
        this.configLicenseDeclarations(licenseDeclarations);
        this.configUrlDeclarations(urlDeclarations);
        this.configCheckUrls(allowUrlsCheckedDaysBefore);
    }

    private void configCheckUrls(int allowUrlsCheckedDaysBefore) {
        if (allowUrlsCheckedDaysBefore > 0) {
            this.lOracle.allowUrlsCheckedDaysBefore(allowUrlsCheckedDaysBefore);
        }
    }

    private void configUrlDeclarations(List<UrlDeclaration> urlDeclarations) {
        urlDeclarations.forEach(ud -> {
            LicenseID license = this.lOracle.getOrThrowByName(ud.getLicense());
            this.lOracle.addUrlCheckedAt(license, ud.getUrl(), ud.getCheckedAt());
            this.log.debug("setting " + ud.getUrl() + " -> " + license + ", check at " + ud.getCheckedAt());
        });
    }

    private void configLicenseDeclarations(List<LicenseDeclaration> licenseDeclarations) {
        licenseDeclarations.forEach(excl -> {
            Coordinates coo = excl.getCoordinates();
            LicenseID license = this.lOracle.getOrThrowByName(excl.getLicense());
            this.lOracle.addLicenseForArtifact(coo, license);
            this.log.debug("setting " + coo + " -> " + license);
        });
    }

    public void getDependencies() {
        this.getPluginsAndTheirDependencies();
        this.getNormalDependencies();
    }

    private void getNormalDependencies() {
        ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("test");
        DependencyNode rootNode = (DependencyNode)Unchecked.u(() -> this.lambda$getNormalDependencies$93((ArtifactFilter)artifactFilter));
        rootNode.accept(new DependencyNodeVisitor(){

            public boolean visit(DependencyNode dependencyNode) {
                Artifact a = (Artifact)NonnullCheck._nn((Object)((DependencyNode)NonnullCheck._nn((Object)dependencyNode)).getArtifact());
                Coordinates coo = Coordinates.valueOf(a);
                LicenseCheckMojo.this.coordinates2License.add(coo);
                LicenseCheckMojo.this.coordinates2License.updateScope(coo, (String)NullCheck._orElseGet((Object)a.getScope(), (Object)"compile"));
                if (!LicenseCheckMojo.this.self.isPresent()) {
                    LicenseCheckMojo.this.self = Optional.of(coo);
                }
                return true;
            }

            public boolean endVisit(DependencyNode dependencyNode) {
                return true;
            }
        });
    }

    private void getPluginsAndTheirDependencies() {
        ((Build)NonnullCheck._nn((Object)this.mavenProject.getBuild())).getPlugins().forEach(plugin -> {
            Coordinates plugCoo = new Coordinates((String)NonnullCheck._nn((Object)plugin.getGroupId()), (String)NonnullCheck._nn((Object)plugin.getArtifactId()), (String)NonnullCheck._nn((Object)plugin.getVersion()));
            this.coordinates2License.add(plugCoo);
            this.coordinates2License.updateScope(plugCoo, "plugin");
            List deps = (List)NonnullCheck._nn((Object)plugin.getDependencies());
            deps.forEach(d -> {
                Coordinates dCoo = new Coordinates((String)NonnullCheck._nn((Object)d.getGroupId()), (String)NonnullCheck._nn((Object)d.getArtifactId()), (String)NonnullCheck._nn((Object)d.getVersion()));
                this.coordinates2License.add(dCoo);
                this.coordinates2License.updateScope(dCoo, "plugin");
            });
        });
    }

    public void determineMavenLicenses() {
        this.log.debug("-- determine licenses --");
        this.coordinates2License.update(this::getMavenLicenseInfo);
    }

    private void getMavenLicenseInfo(Coordinates coo, Coordinates2License.LiCo lico) {
        List<License> mavenLicenses = this.mlo.getMavenLicense(coo);
        lico.setMLicenses(mavenLicenses.stream().map(l -> new Coordinates2License.MLicense((String)NullCheck._orElseGet((Object)l.getName(), (Object)""), (String)NullCheck._orElseGet((Object)l.getUrl(), (Object)""), (String)NullCheck._orElseGet((Object)l.getComments(), (Object)""))).collect(Collectors.toList()));
    }

    public String checkCompatibility(Coordinates coo, String licenseStr) {
        LicenseID license = this.lOracle.getOrThrowByName(licenseStr);
        AtomicReference<String> ret = new AtomicReference<String>("");
        this.lOracle.getAttributes(license).isFedoraApproved().ifPresent(fed -> {
            if (!fed.booleanValue()) {
                ret.set("bad license " + license + " used by " + coo + "  (not approved by fedora)");
            }
        });
        if (!this.self.isPresent()) {
            return "";
        }
        Optional<Coordinates2License.LiCo> info = this.coordinates2License.get((Coordinates)NonnullCheck._nn((Object)this.self.get()));
        if (!info.isPresent() || !((Coordinates2License.LiCo)NonnullCheck._nn((Object)info.get())).getLicense().isPresent()) {
            return "no license on current artifact";
        }
        LicenseID mine = this.lOracle.getOrThrowByName((String)NonnullCheck._nn((Object)((Coordinates2License.LiCo)NonnullCheck._nn((Object)info.get())).getLicense().get()));
        if (mine.equals(license)) {
            return "";
        }
        if (this.lOracle.getAttributes(mine).isCopyLeftDef()) {
            this.lOracle.getAttributes(license).isGpl2Compatible().ifPresent(gc -> {
                if (!gc.booleanValue()) {
                    ret.set("not gpl2 compatible: " + license + " used by " + coo);
                }
            });
            this.lOracle.getAttributes(license).isGpl3Compatible().ifPresent(gc -> {
                if (!gc.booleanValue()) {
                    ret.set("not gpl2 compatible: " + license + " used by " + coo);
                }
            });
        }
        if (!this.lOracle.getAttributes(mine).isCopyLeftDef() && this.lOracle.getAttributes(license).isCopyLeftDef()) {
            ret.set("can't depend on a copy left license: " + license + " used by " + coo);
        }
        return (String)NonnullCheck._nn((Object)ret.get());
    }

    public void checkCompatibility() {
        this.coordinates2License.checkCompatibility(this::checkCompatibility);
    }

    public void getHolder() {
        GetHolder gh = new GetHolder(this.lOracle, this.mlo, this.log);
        this.coordinates2License.getHolders(gh::getHolder);
    }

    public void summery() {
        this.coordinates2License.summery();
    }

    public void src() {
        SrcAccess src = new SrcAccess(this.lOracle, this.mlo, this.log, this.andIsOr);
        this.coordinates2License.fromSrc(src::check);
    }

    public void store() {
        JSONStartup.previousOut(this.coordinates2License);
    }

    public void jars() {
        JarAccess src = new JarAccess(this.lOracle, this.mlo, this.log, this.andIsOr);
        this.coordinates2License.fromJar(src::check);
    }

    public void computeHolder() {
        this.coordinates2License.update(this::computeHolder);
    }

    private void computeHolder(Coordinates coordinates, Coordinates2License.LiCo liCo) {
        Optional<CopyrightHolder> ret = liCo.getMavenLicenses().stream().map(ml -> ContentToLicense.copyRightPattern.matcher((CharSequence)NonnullCheck._orElseGet((Object)ml.getComment(), (Object)""))).filter(Matcher::matches).map(m -> new CopyrightHolder((String)NonnullCheck._nn((Object)m.group("year")), (String)NonnullCheck._nn((Object)m.group("holder")))).findAny();
        if (ret.isPresent()) {
            liCo.setHolder(ret);
            return;
        }
        ret = new ContentToLicense(this.lOracle, "by license file", this.log, this.andIsOr).getHolder(liCo.getLicenseTxt());
        if (ret.isPresent()) {
            liCo.setHolder(ret);
            return;
        }
        ret = new ContentToLicense(this.lOracle, "by header file", this.log, this.andIsOr).getHolder(liCo.getHeaderTxt());
        if (ret.isPresent()) {
            liCo.setHolder(ret);
            return;
        }
        ret = new ContentToLicense(this.lOracle, "by notice file", this.log, this.andIsOr).getHolder(liCo.getNotice());
        if (ret.isPresent()) {
            liCo.setHolder(ret);
        }
    }

    public void getNotice() {
        GetHolder gh = new GetHolder(this.lOracle, this.mlo, this.log);
        this.coordinates2License.update(gh::getNotice);
    }

    public void getPomHeader() {
        SrcAccess src = new SrcAccess(this.lOracle, this.mlo, this.log, this.andIsOr);
        this.coordinates2License.fromSrc(src::getPomHeader);
    }

    public void generateNotice() {
        this.coordinates2License.generateNotice();
    }

    public void computeLicense() {
        this.coordinates2License.update(new LicenseIntelligence(this.lOracle, this.log)::compute);
    }

    public void downloadPages() {
        this.coordinates2License.update(new Downloader(this.log, this.urlToLicense, this.lOracle)::getExtension);
    }

    private /* synthetic */ DependencyNode lambda$getNormalDependencies$93(ArtifactFilter artifactFilter) throws DependencyGraphBuilderException {
        return (DependencyNode)NonnullCheck._nn((Object)this.dependencyGraphBuilder.buildDependencyGraph(this.mavenProject, artifactFilter));
    }
}

