/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.mojo;

import com.google.gson.Gson;
import de.pfabulist.frex.Frex;
import de.pfabulist.kleinod.nio.Filess;
import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.loracle.buildup.JSONStartup;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.Coordinates2License;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.license.Normalizer;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.loracle.mojo.Url2License;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import de.pfabulist.unchecked.Unchecked;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class Downloader {
    private final Findings log;
    private final Url2License url2License;
    Normalizer normalizer = new Normalizer();
    private boolean noInternet = true;
    private final LOracle lOracle;
    private static final String urlspecial = Frex.or((Frex[])new Frex[]{Frex.txt((char)':'), Frex.txt((char)'/')}).buildPattern().toString();

    public Downloader(Findings log, Url2License url2License, LOracle lOracle) {
        this.log = log;
        this.url2License = url2License;
        this.lOracle = lOracle;
    }

    public void get(Coordinates coordinates, Coordinates2License.LiCo liCo) {
        if (!liCo.getLicenseTxt().isEmpty()) {
            return;
        }
        if (liCo.getMavenLicenses().isEmpty()) {
            Downloader.getLico(coordinates).ifPresent(stored -> {
                if (stored.getMavenLicenses().isEmpty() || ((Coordinates2License.MLicense)NonnullCheck._nn((Object)stored.getMavenLicenses().get(0))).getUrl().isEmpty()) {
                    this.log.warn("[huh]");
                    return;
                }
                liCo.setMavenLicenses(stored.getMavenLicenses());
                this.log.debug("found stored information for " + coordinates);
            });
        }
        liCo.getMavenLicenses().stream().map(Coordinates2License.MLicense::getUrl).filter(u -> !u.isEmpty()).forEach(this::download);
    }

    public void getExtension(Coordinates coordinates, Coordinates2License.LiCo liCo) {
        if (!liCo.getLicenseTxt().isEmpty()) {
            return;
        }
        Downloader.getLico(coordinates).ifPresent(stored -> {
            liCo.setMavenLicenses(stored.getMavenLicenses());
            this.log.debug("found stored information for " + coordinates);
        });
    }

    public void download(String url) {
        this.log.debug("[download?] " + url);
        Path path = (Path)NonnullCheck._nn((Object)Paths.get("", new String[0]).resolve("target/generated-sources/loracle/url/" + this.getUrlPath(url)));
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        Filess.createDirectories((Path)((Path)NonnullCheck._nn((Object)path.getParent())), (FileAttribute[])new FileAttribute[0]);
        Optional<String> res = this.lOracle.getUrlContent(url);
        if (!res.isPresent()) {
            this.log.debug("    url not known: " + url);
            return;
        }
        try (InputStream is2 = this.getClass().getResourceAsStream(res.get());){
            if (is2 == null) {
                this.log.debug("    not found: " + this.getUrlPath(url));
                return;
            }
            Files.copy(is2, path, new CopyOption[0]);
            this.log.debug("    found stored in loracle");
            return;
        }
        catch (IOException is2) {
            if (this.noInternet) {
                this.log.warn("       not found " + url);
                this.log.warn("[try]  add page src as resource: /de/pfabulist/loracle/urls/" + this.getUrlPath(url));
                this.log.warn("       see loracle-maven-plugin docu for more details");
                return;
            }
            this.log.debug("    trying ");
            try {
                Files.write(path, Strings.getBytes((String)((String)NonnullCheck._nn((Object)((Element)NonnullCheck._nn((Object)((Document)NonnullCheck._nn((Object)Jsoup.connect((String)url).get())).body())).text()))), new OpenOption[0]);
                this.log.debug("    success ");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.warn("no internet or 404: " + url);
                return;
            }
            return;
        }
    }

    private String getUrlPath(String url) {
        String u = this.normalizer.normalizeUrl(url).orElse(url);
        return u.replaceAll(urlspecial, "_");
    }

    public String get(String u) {
        Path path = (Path)NonnullCheck._nn((Object)Paths.get("", new String[0]).resolve("target/generated-sources/loracle/url/" + this.getUrlPath(u)));
        if (!Files.exists(path, new LinkOption[0])) {
            return "";
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.log.debug("[huh url?] " + path);
            return "";
        }
        return Strings.newString((byte[])Filess.readAllBytes((Path)path));
    }

    public void setNoInternet() {
        this.noInternet = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Coordinates2License.LiCo> getLico(Coordinates coo) {
        byte[] buf = new byte[3000000];
        int got = 0;
        try (InputStream in = JSONStartup.class.getResourceAsStream("/de/pfabulist/loracle/coordinates/" + coo.toFilename() + ".json");){
            int once;
            if (in == null) {
                Optional<Coordinates2License.LiCo> optional = Optional.empty();
                return optional;
            }
            while ((once = in.read(buf, got, 3000000 - got)) >= 0) {
                got += once;
            }
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
        String jsonstr = new String(buf, 0, got, StandardCharsets.UTF_8);
        return Optional.of(new Gson().fromJson(jsonstr, Coordinates2License.LiCo.class));
    }
}

