/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import com.esotericsoftware.minlog.Log;
import de.pfabulist.frex.CharacterClass;
import de.pfabulist.frex.Frex;
import de.pfabulist.kleinod.collection.P;
import de.pfabulist.loracle.license.And;
import de.pfabulist.loracle.license.CompositeLicense;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.FuzzyParser;
import de.pfabulist.loracle.license.LicenseAttributes;
import de.pfabulist.loracle.license.LicenseExclude;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.MappedLicense;
import de.pfabulist.loracle.license.ModifiedSingleLicense;
import de.pfabulist.loracle.license.Normalizer;
import de.pfabulist.loracle.license.SPDXParser;
import de.pfabulist.loracle.license.SingleLicense;
import de.pfabulist.loracle.spi.CustomService;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import de.pfabulist.unchecked.NullCheck;
import de.pfabulist.unchecked.functiontypes.ConsumerE;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"})
public class LOracle {
    private Map<String, More> singles = new TreeMap<String, More>(String::compareTo);
    private Map<String, Boolean> licenseExceptions = new HashMap<String, Boolean>();
    private Map<String, More> composites = new HashMap<String, More>();
    private Map<String, P<String, String>> urlsInTime = new TreeMap<String, P<String, String>>(String::compareTo);
    private final transient Map<String, Set<LicenseID>> couldbeNames = new HashMap<String, Set<LicenseID>>();
    private final transient Map<String, Set<LicenseID>> couldbeUrls = new HashMap<String, Set<LicenseID>>();
    private final transient SPDXParser parser;
    private final transient Normalizer normalizer = new Normalizer();
    private transient Map<Coordinates, LicenseID> coordinatesMap = new HashMap<Coordinates, LicenseID>();
    private transient Map<String, LicenseID> longNameMapper = new HashMap<String, LicenseID>();
    private transient Map<String, LicenseID> urls = new HashMap<String, LicenseID>();
    private Map<String, String> urlToContent = new HashMap<String, String>();
    private List<String> tooSimpleLongNames = new ArrayList<String>();
    private static Pattern withVersion = Frex.any().oneOrMore().lazy().var("base").then((Frex)Frex.txt((char)' ')).then((Frex)Frex.or((Frex[])new Frex[]{Frex.number(), Frex.txt((char)'.')}).oneOrMore()).buildCaseInsensitivePattern();
    private static final Pattern orLater = Frex.any().oneOrMore().var("base").then(Frex.txt((String)" or later")).buildCaseInsensitivePattern();
    private static final Pattern urlWithLongname = Frex.any().oneOrMore().lazy().then((Frex)Frex.txt((char)'/')).then(Frex.anyBut((CharacterClass)Frex.txt((char)'/')).oneOrMore().var("fname")).buildCaseInsensitivePattern();
    public static final Frex ws = Frex.or((Frex[])new Frex[]{Frex.whitespace(), Frex.txt((char)'\r'), Frex.txt((char)'\n')});

    public LOracle() {
        this.parser = new SPDXParser(this);
    }

    public LOracle spread() {
        if (!this.longNameMapper.isEmpty()) {
            throw new IllegalStateException("can only be called after json construction");
        }
        this.singles.forEach((name, more) -> {
            SingleLicense lid = new SingleLicense((String)name);
            more.urls.forEach(u -> this.urls.put((String)u, lid));
            more.longNames.forEach(l -> this.longNameMapper.putIfAbsent((String)l, lid));
            more.specific.forEach(coo -> this.coordinatesMap.putIfAbsent((Coordinates)coo, lid));
            more.couldbeName.forEach(n -> {
                this.couldbeNames.putIfAbsent((String)n, new HashSet());
                ((Set)NonnullCheck._nn(this.couldbeNames.get(n))).add(lid);
            });
            more.couldbeUrl.forEach(n -> {
                this.couldbeUrls.putIfAbsent((String)n, new HashSet());
                ((Set)NonnullCheck._nn(this.couldbeUrls.get(n))).add(lid);
            });
        });
        this.composites.forEach((name, more) -> {
            LicenseID lid = this.getOrThrowByName((String)name);
            more.urls.forEach(u -> this.urls.put((String)u, lid));
            more.longNames.forEach(l -> this.longNameMapper.putIfAbsent((String)l, lid));
            more.specific.forEach(coo -> this.coordinatesMap.putIfAbsent((Coordinates)coo, lid));
            more.couldbeName.forEach(n -> {
                this.couldbeNames.putIfAbsent((String)n, new HashSet());
                ((Set)NonnullCheck._nn(this.couldbeNames.get(n))).add(lid);
            });
            more.couldbeUrl.forEach(n -> {
                this.couldbeUrls.putIfAbsent((String)n, new HashSet());
                ((Set)NonnullCheck._nn(this.couldbeUrls.get(n))).add(lid);
            });
        });
        CustomService.getInstance().getAll().forEach(c -> {
            c.getCustomLicenses().forEach(l -> {
                try {
                    SingleLicense lid = this.newSingle(l.getId(), false);
                    this.addUrl(lid, l.getUrl());
                }
                catch (Exception e) {
                    Log.warn((String)("custom license is known (ignored) " + l.getId()));
                }
            });
            c.getCoordinates().forEach(co -> {
                try {
                    Coordinates coo = Coordinates.valueOf(co.getCoordinates());
                    if (!co.getLicense().isEmpty()) {
                        LicenseID li = this.getOrThrowByName(co.getLicense());
                        this.addLicenseForArtifact(coo, li);
                    }
                }
                catch (Exception e) {
                    Log.warn((String)("custom coordinates to license setting flawed " + co.getCoordinates()));
                }
            });
            c.getUrls().forEach(u -> this.addUrlContent(u.getUrl(), u.getResource()));
        });
        return this;
    }

    public LicenseID getOrLater(SingleLicense license, boolean orLater, Optional<LicenseExclude> exception) {
        if (!orLater && !exception.isPresent()) {
            return license;
        }
        ModifiedSingleLicense ret = new ModifiedSingleLicense(license, orLater, exception);
        this.composites.putIfAbsent(ret.getId(), new More(this.getMore((LicenseID)license).attributes.isSPDX()));
        if (!exception.isPresent()) {
            this.getMore((LicenseID)ret).attributes.setCopyLeft(this.getMore((LicenseID)license).attributes.isCopyLeftDef());
        }
        return ret;
    }

    public LicenseExclude getExceptionOrThrow(String ex) {
        String lower = ex.trim().toLowerCase(Locale.US);
        if (this.licenseExceptions.containsKey(lower)) {
            return new LicenseExclude(lower);
        }
        throw new IllegalArgumentException("no such exception: " + ex);
    }

    public static String trim(String in) {
        return ((String)NonnullCheck._nn((Object)in.toLowerCase(Locale.US))).replaceAll(",", " ").trim();
    }

    public SingleLicense newSingle(String name, More more) {
        if (this.getByName(name).isPresent()) {
            throw new IllegalArgumentException("not a new license");
        }
        this.singles.put(name, more);
        return new SingleLicense(name);
    }

    public SingleLicense newSingle(String name, boolean spdx) {
        String lower = LOracle.trim(name);
        if (this.getByName(lower).isPresent()) {
            throw new IllegalArgumentException("not a new single license: " + name);
        }
        Set<LicenseID> guesses = this.guessByName(lower);
        if (!guesses.isEmpty()) {
            this.removeNameGuess(lower);
        }
        this.singles.put(lower, new More(spdx));
        SingleLicense ret = new SingleLicense(lower);
        String lng = Arrays.stream(lower.split("[- ]")).collect(Collectors.joining(" "));
        this.addLongName(ret, lng);
        return ret;
    }

    private void removeNameGuess(String name) {
        if (!name.equals("w3c")) {
            throw new IllegalArgumentException("not a new single license: " + name);
        }
        Log.warn((String)("removing could be (so that it can be a new single id) " + name));
        Set<LicenseID> guesses = this.guessByName(name);
        this.couldbeNames.remove(name);
        guesses.stream().forEach(l -> this.getMore((LicenseID)l).couldbeName.remove(name));
    }

    public More getMore(LicenseID licenseID) {
        return (More)NullCheck._orElseGet((Object)this.singles.get(licenseID.getId()), () -> (More)NullCheck._orElseThrow((Object)this.composites.get(licenseID.getId()), () -> new IllegalArgumentException("no such license: " + licenseID)));
    }

    public LicenseAttributes getAttributes(LicenseID l) {
        return this.getMore((LicenseID)l).attributes;
    }

    public void addLongName(LicenseID license, String longName) {
        String reduced = this.normalizer.reduce(longName);
        if (this.longNameMapper.containsKey(reduced)) {
            if (license.equals(this.longNameMapper.get(reduced))) {
                return;
            }
            throw new IllegalArgumentException("mapped already <" + longName + "> (" + reduced + ") as " + license + " <" + this.longNameMapper.get(reduced) + ">");
        }
        this.longNameMapper.put(reduced, license);
        this.getMore((LicenseID)license).longNames.add(reduced);
        Matcher versioned = withVersion.matcher(reduced);
        if (versioned.matches()) {
            this.addCouldbeName(license, (String)NonnullCheck._nn((Object)versioned.group("base")));
        }
        if (reduced.contains("gnu")) {
            if (reduced.contains("lesser")) {
                this.addCouldbeName(license, "gnu lesser");
            } else if (reduced.contains("affero")) {
                this.addCouldbeName(license, "affero gnu");
                this.addCouldbeName(license, "affero");
            } else {
                this.addCouldbeName(license, "gnu");
            }
        } else if (reduced.contains("affero")) {
            this.addCouldbeName(license, "affero gnu");
            this.addCouldbeName(license, "affero");
        } else if (reduced.contains("bsd")) {
            this.addCouldbeName(license, "bsd");
        }
    }

    public Optional<SingleLicense> getSingle(String name) {
        String lower = name.trim().toLowerCase(Locale.US);
        if (!this.singles.containsKey(lower)) {
            return Optional.empty();
        }
        return Optional.of(new SingleLicense(lower));
    }

    public Optional<LicenseID> getByName1(String name) {
        try {
            return Optional.of(this.parser.parse(name));
        }
        catch (Exception exception) {
            return Optional.ofNullable(this.longNameMapper.get(this.normalizer.reduce(name)));
        }
    }

    public MappedLicense getByName(String name) {
        if (name.isEmpty()) {
            return MappedLicense.empty("no name");
        }
        try {
            return MappedLicense.of(this.parser.parse(name), "by parsed name: " + name);
        }
        catch (Exception exception) {
            Optional<LicenseID> ret;
            boolean plus = false;
            String base = name;
            Matcher matcher = orLater.matcher(name);
            if (matcher.matches()) {
                base = (String)NonnullCheck._nn((Object)matcher.group("base"));
                plus = true;
            }
            if ((ret = Optional.ofNullable(this.longNameMapper.get(this.normalizer.reduce(base)))).isPresent()) {
                if (plus) {
                    if (ret.get() instanceof SingleLicense) {
                        return MappedLicense.of(this.getOrLater((SingleLicense)NonnullCheck._nn((Object)ret.get()), true, Optional.empty()), "by normalized name and 'or later': " + name);
                    }
                    return MappedLicense.empty(" or later with composite (?)");
                }
                return MappedLicense.of(ret, "by normalized name: " + name);
            }
            try {
                return MappedLicense.of(new FuzzyParser(this).parse(name), "by fuzzy parsing name: " + name);
            }
            catch (Exception e) {
                return MappedLicense.empty("unknown name");
            }
        }
    }

    public LicenseID getOrThrowByName(String name) {
        return this.getByName(name).orElseThrow(() -> new IllegalArgumentException("no such license name: " + name));
    }

    public void addLicenseForArtifact(Coordinates coo, LicenseID licenseID) {
        this.getMore((LicenseID)licenseID).specific.add(coo);
        this.coordinatesMap.put(coo, licenseID);
    }

    public MappedLicense getByCoordinates(Coordinates coo) {
        Optional<LicenseID> ret = Optional.ofNullable(this.coordinatesMap.get(coo));
        if (ret.isPresent()) {
            return MappedLicense.of(ret, "by direct coordinates");
        }
        return this.coordinatesMap.keySet().stream().filter(c -> c.matches(coo)).findAny().map(c -> MappedLicense.of((LicenseID)NonnullCheck._nn((Object)this.coordinatesMap.get(c)), "by patterned coordinates " + c)).orElse(MappedLicense.empty());
    }

    public void addException(String name, boolean spdx) {
        String lower = name.trim().toLowerCase(Locale.US);
        if (this.licenseExceptions.containsKey(lower)) {
            throw new IllegalArgumentException("existing exception: " + lower);
        }
        this.licenseExceptions.put(lower, spdx);
    }

    public MappedLicense getByUrl(String url) {
        Optional<String> rel = this.normalizer.normalizeUrl(url);
        if (!rel.isPresent()) {
            return MappedLicense.empty();
        }
        Optional<LicenseID> ret = Optional.ofNullable(this.urls.get(rel.get()));
        if (ret.isPresent()) {
            if (this.urlsInTime.containsKey(rel.get())) {
                return MappedLicense.of(ret, "by url " + url + " checked at: " + (String)((P)NonnullCheck._nn(this.urlsInTime.get((Object)rel.get()))).i0);
            }
            return MappedLicense.of(ret, "by url " + url);
        }
        Matcher end = urlWithLongname.matcher((CharSequence)NonnullCheck._nn((Object)rel.get()));
        if (!end.matches()) {
            Log.debug((String)("not a url with path ? " + url + " reduced: " + rel));
            return MappedLicense.empty();
        }
        MappedLicense ml = this.getByName((String)NonnullCheck._nn((Object)end.group("fname")));
        if (ml.isPresent()) {
            return ml.addReason("by name match of url: " + url);
        }
        return MappedLicense.empty();
    }

    public void setOsiApproval(LicenseID licenseID, boolean osiApproved) {
        this.getMore((LicenseID)licenseID).attributes.setOsiApproved(osiApproved);
    }

    public CompositeLicense getAnd(LicenseID left, LicenseID right) {
        CompositeLicense ret = new CompositeLicense(false, left, right);
        More mLeft = this.getMore(left);
        More mRight = this.getMore(right);
        this.composites.putIfAbsent(ret.getId(), new More(mLeft.attributes.isSPDX() && mRight.attributes.isSPDX()));
        this.getMore((LicenseID)ret).attributes.setCopyLeft(mLeft.attributes.isCopyLeftDef() || mRight.attributes.isCopyLeftDef());
        return ret;
    }

    public CompositeLicense getOr(LicenseID left, LicenseID right) {
        CompositeLicense ret = new CompositeLicense(true, left, right);
        More mLeft = this.getMore(left);
        More mRight = this.getMore(right);
        this.composites.putIfAbsent(ret.getId(), new More(mLeft.attributes.isSPDX() && mRight.attributes.isSPDX()));
        this.getMore((LicenseID)ret).attributes.setCopyLeft(mLeft.attributes.isCopyLeftDef() && mRight.attributes.isCopyLeftDef());
        return ret;
    }

    public void addCouldbeName(LicenseID license, String couldbe) {
        this.getByName(couldbe).ifPresent((ConsumerE<LicenseID, Exception>)((ConsumerE)l -> new IllegalArgumentException("name is already set to definitive license: " + couldbe + " -> " + l)));
        this.getMore((LicenseID)license).couldbeName.add(couldbe);
        this.couldbeNames.putIfAbsent(couldbe, new HashSet());
        this.couldbeNames.get(couldbe).add(license);
    }

    public Set<LicenseID> guessByName(String name) {
        return Optional.ofNullable(this.couldbeNames.get(this.normalizer.reduce(name))).orElseGet(Collections::emptySet);
    }

    public Set<LicenseID> guessByUrl(String url) {
        return this.normalizer.normalizeUrl(url).map(u -> (Set)NullCheck._orElseGet(this.couldbeUrls.get(u), new HashSet())).orElseGet(HashSet::new);
    }

    public void addCouldBeUrl(LicenseID license, String url) {
    }

    public void addUrl(LicenseID license, String url) {
        String rel = this.normalizer.normalizeUrl(url).orElseThrow(() -> new IllegalArgumentException("not a url"));
        if (this.urls.containsKey(rel)) {
            LicenseID old = (LicenseID)NonnullCheck._nn((Object)this.urls.get(rel));
            if (old.equals(license)) {
                return;
            }
            Log.info((String)("known url: " + url + " as: " + old + "  moving it to couldbe, together with " + license));
            this.urls.remove(rel);
            More oldMore = this.getMore(old);
            oldMore.urls.remove(rel);
            oldMore.couldbeUrl.add(rel);
            More thisMore = this.getMore(license);
            thisMore.couldbeUrl.add(rel);
            this.couldbeUrls.putIfAbsent(rel, new HashSet());
            this.couldbeUrls.get(rel).add(license);
            this.couldbeUrls.get(rel).add(old);
            return;
        }
        if (this.couldbeUrls.containsKey(rel)) {
            Set could = (Set)NonnullCheck._nn(this.couldbeUrls.get(rel));
            if (could.size() > 1) {
                if (could.contains(license)) {
                    return;
                }
                could.add(license);
                this.getMore((LicenseID)license).couldbeUrl.add(rel);
                return;
            }
            throw new IllegalArgumentException("unique could be ?: " + rel + " " + license);
        }
        this.getMore((LicenseID)license).urls.add(rel);
        this.urls.put(rel, license);
    }

    public void addUrlCheckedAt(LicenseID license, String url, String date) {
        Log.info((String)("added url checkedat " + url + " " + license + " " + date));
        String norm = this.normalizer.normalizeUrl(url).orElseThrow(() -> new IllegalArgumentException("can't normalize this url: " + url));
        this.urlsInTime.put(norm, (P<String, String>)P.of((Object)date, (Object)license.toString()));
    }

    public void allowUrlsCheckedDaysBefore(int days) {
        LocalDate now = LocalDate.now();
        this.urlsInTime.forEach((u, p) -> {
            try {
                LocalDate checked = (LocalDate)NonnullCheck._nn((Object)LocalDate.parse((CharSequence)p.i0));
                if (ChronoUnit.DAYS.between(checked, now) < (long)days) {
                    this.addUrl(this.getOrThrowByName((String)p.i1), (String)u);
                    Log.info((String)("url " + u + " was checked to be " + (String)p.i1));
                } else {
                    Log.warn((String)("url " + u + " was checked too long ago: days " + checked));
                }
            }
            catch (DateTimeParseException e) {
                Log.warn((String)("not a date " + (String)p.i0));
            }
        });
    }

    public int getSingleLicenseCount() {
        return this.singles.size();
    }

    public Pattern fullNames(String lng) {
        return Arrays.stream(lng.split(" ")).map(w -> Frex.fullWord((String)w).then(ws)).reduce(Frex.txt((String)""), Frex::then).buildCaseInsensitivePattern();
    }

    public MappedLicense findLongNames(And and, String str) {
        String norm = this.normalizer.reduce(str);
        return this.longNameMapper.entrySet().stream().map(e -> {
            String name = (String)NonnullCheck._nn(e.getKey());
            LicenseID li = (LicenseID)NonnullCheck._nn(e.getValue());
            if (!this.tooSimpleLongNames.contains(name) && this.fullNames(name).matcher(norm).find()) {
                return MappedLicense.of(li, "found name");
            }
            return MappedLicense.empty();
        }).reduce(MappedLicense.empty(), and::and);
    }

    public void addTooSimple(String ... strs) {
        this.tooSimpleLongNames.addAll(Arrays.asList(strs));
    }

    public Optional<String> getUrlContent(String url) {
        return this.normalizer.normalizeUrl(url).flatMap(u -> Optional.ofNullable(this.urlToContent.get(u)));
    }

    public void addUrlContent(String url, String res) {
        Optional<String> u = this.normalizer.normalizeUrl(url);
        if (!u.isPresent()) {
            throw new IllegalArgumentException("huhh");
        }
        this.urlToContent.put(u.get(), res);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class More {
        public LicenseAttributes attributes;
        public List<String> urls = new ArrayList<String>();
        public List<String> longNames = new ArrayList<String>();
        public List<Coordinates> specific = new ArrayList<Coordinates>();
        public Set<String> couldbeName = new HashSet<String>();
        public Set<String> couldbeUrl = new HashSet<String>();

        public More(boolean spdx) {
            this.attributes = new LicenseAttributes();
            this.attributes.setSPDX(spdx);
        }
    }
}

