/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.mojo;

import de.pfabulist.loracle.attribution.CopyrightHolder;
import de.pfabulist.loracle.attribution.GetHolder;
import de.pfabulist.loracle.attribution.JarAccess;
import de.pfabulist.loracle.attribution.SrcAccess;
import de.pfabulist.loracle.buildup.JSONStartup;
import de.pfabulist.loracle.license.And;
import de.pfabulist.loracle.license.ContentToLicense;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.Coordinates2License;
import de.pfabulist.loracle.license.Decider;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.license.LicenseFromText;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.MappedLicense;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.loracle.mojo.LicenseDeclaration;
import de.pfabulist.loracle.mojo.MavenLicenseOracle;
import de.pfabulist.loracle.mojo.UrlDeclaration;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import de.pfabulist.unchecked.NullCheck;
import de.pfabulist.unchecked.Unchecked;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Build;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class LicenseCheckMojo {
    private final Findings log;
    private final MavenLicenseOracle mlo;
    private final LOracle lOracle;
    private final MavenProject mavenProject;
    private final DependencyGraphBuilder dependencyGraphBuilder;
    private final boolean andIsOr;
    private Optional<Coordinates> self = Optional.empty();
    private final Coordinates2License coordinates2License;

    public LicenseCheckMojo(Findings log, Path localRepo, MavenProject project, DependencyGraphBuilder dependencyGraphBuilder, boolean andIsOr) {
        this.log = log;
        this.dependencyGraphBuilder = dependencyGraphBuilder;
        this.mlo = new MavenLicenseOracle(log, localRepo);
        this.lOracle = JSONStartup.start().spread();
        this.mavenProject = project;
        this.andIsOr = andIsOr;
        log.info("---------------------------------------");
        log.info("      loracle license check            ");
        log.info("---------------------------------------");
        this.coordinates2License = JSONStartup.previous(andIsOr);
        this.coordinates2License.setLog(log);
    }

    public void config(List<LicenseDeclaration> licenseDeclarations, List<UrlDeclaration> urlDeclarations, int allowUrlsCheckedDaysBefore) {
        this.configLicenseDeclarations(licenseDeclarations);
        this.configUrlDeclarations(urlDeclarations);
        this.configCheckUrls(allowUrlsCheckedDaysBefore);
    }

    private void configCheckUrls(int allowUrlsCheckedDaysBefore) {
        if (allowUrlsCheckedDaysBefore > 0) {
            this.lOracle.allowUrlsCheckedDaysBefore(allowUrlsCheckedDaysBefore);
        }
    }

    private void configUrlDeclarations(List<UrlDeclaration> urlDeclarations) {
        urlDeclarations.forEach(ud -> {
            LicenseID license = this.lOracle.getOrThrowByName(ud.getLicense());
            this.lOracle.addUrlCheckedAt(license, ud.getUrl(), ud.getCheckedAt());
            this.log.debug("setting " + ud.getUrl() + " -> " + license + ", check at " + ud.getCheckedAt());
        });
    }

    private void configLicenseDeclarations(List<LicenseDeclaration> licenseDeclarations) {
        licenseDeclarations.forEach(excl -> {
            Coordinates coo = excl.getCoordinates();
            LicenseID license = this.lOracle.getOrThrowByName(excl.getLicense());
            this.lOracle.addLicenseForArtifact(coo, license);
            this.log.debug("setting " + coo + " -> " + license);
        });
    }

    public void getDependencies() {
        this.getPluginsAndTheirDependencies();
        this.getNormalDependencies();
    }

    private void getNormalDependencies() {
        ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("test");
        DependencyNode rootNode = (DependencyNode)Unchecked.u(() -> this.lambda$getNormalDependencies$70((ArtifactFilter)artifactFilter));
        rootNode.accept(new DependencyNodeVisitor(){

            public boolean visit(DependencyNode dependencyNode) {
                Artifact a = (Artifact)NonnullCheck._nn((Object)dependencyNode.getArtifact());
                Coordinates coo = Coordinates.valueOf(a);
                LicenseCheckMojo.this.coordinates2License.add(coo);
                LicenseCheckMojo.this.coordinates2License.updateScope(coo, (String)NullCheck._orElseGet((Object)a.getScope(), (Object)"compile"));
                if (!LicenseCheckMojo.this.self.isPresent()) {
                    LicenseCheckMojo.this.self = Optional.of(coo);
                }
                return true;
            }

            public boolean endVisit(DependencyNode dependencyNode) {
                return true;
            }
        });
    }

    private void getPluginsAndTheirDependencies() {
        ((Build)NonnullCheck._nn((Object)this.mavenProject.getBuild())).getPlugins().forEach(plugin -> {
            Coordinates plugCoo = new Coordinates((String)NonnullCheck._nn((Object)plugin.getGroupId()), (String)NonnullCheck._nn((Object)plugin.getArtifactId()), (String)NonnullCheck._nn((Object)plugin.getVersion()));
            this.coordinates2License.add(plugCoo);
            this.coordinates2License.updateScope(plugCoo, "plugin");
            List deps = (List)NonnullCheck._nn((Object)plugin.getDependencies());
            deps.forEach(d -> {
                Coordinates dCoo = new Coordinates((String)NonnullCheck._nn((Object)d.getGroupId()), (String)NonnullCheck._nn((Object)d.getArtifactId()), (String)NonnullCheck._nn((Object)d.getVersion()));
                this.coordinates2License.add(dCoo);
                this.coordinates2License.updateScope(dCoo, "plugin");
            });
        });
    }

    public void determineMavenLicenses() {
        this.log.debug("-- determine licenses --");
        this.coordinates2License.update(this::getMavenLicenseInfo);
    }

    private void getMavenLicenseInfo(Coordinates coo, Coordinates2License.LiCo lico) {
        List<License> mavenLicenses = this.mlo.getMavenLicense(coo);
        lico.setMLicenses(mavenLicenses.stream().map(l -> new Coordinates2License.MLicense((String)NullCheck._orElseGet((Object)l.getName(), (Object)""), (String)NullCheck._orElseGet((Object)l.getUrl(), (Object)""), (String)NullCheck._orElseGet((Object)l.getComments(), (Object)""))).collect(Collectors.toList()));
    }

    private MappedLicense mavenLicenseToLicense(Coordinates2License.MLicense mavenLicense) {
        Optional<String> name = Optional.of(mavenLicense.getName());
        MappedLicense byName = name.map(this.lOracle::getByName).orElse(MappedLicense.empty());
        Optional<String> url = Optional.of(mavenLicense.getUrl());
        MappedLicense byUrl = url.map(this.lOracle::getByUrl).orElse(MappedLicense.empty());
        MappedLicense byComments = new ContentToLicense(this.lOracle, "comments", this.log, this.andIsOr).findLicenses(mavenLicense.getComment());
        mavenLicense.setByName(byName);
        mavenLicense.setByUrl(byUrl);
        mavenLicense.setByComment(byComments);
        return new Decider().decide(byName, byUrl, byComments);
    }

    public String checkCompatibility(Coordinates coo, String licenseStr) {
        LicenseID license = this.lOracle.getOrThrowByName(licenseStr);
        AtomicReference<String> ret = new AtomicReference<String>("");
        this.lOracle.getAttributes(license).isFedoraApproved().ifPresent(fed -> {
            if (!fed.booleanValue()) {
                ret.set("bad license " + license + " used by " + coo + "  (not approved by fedora)");
            }
        });
        if (!this.self.isPresent()) {
            return "";
        }
        Optional<Coordinates2License.LiCo> info = this.coordinates2License.get((Coordinates)NonnullCheck._nn((Object)this.self.get()));
        if (!info.isPresent() || !((Coordinates2License.LiCo)NonnullCheck._nn((Object)info.get())).getLicense().isPresent()) {
            return "no license on current artifact";
        }
        LicenseID mine = this.lOracle.getOrThrowByName((String)NonnullCheck._nn((Object)((Coordinates2License.LiCo)NonnullCheck._nn((Object)info.get())).getLicense().get()));
        if (mine.equals(license)) {
            return "";
        }
        if (this.lOracle.getAttributes(mine).isCopyLeftDef()) {
            this.lOracle.getAttributes(license).isGpl2Compatible().ifPresent(gc -> {
                if (!gc.booleanValue()) {
                    ret.set("not gpl2 compatible: " + license + " used by " + coo);
                }
            });
            this.lOracle.getAttributes(license).isGpl3Compatible().ifPresent(gc -> {
                if (!gc.booleanValue()) {
                    ret.set("not gpl2 compatible: " + license + " used by " + coo);
                }
            });
        }
        if (!this.lOracle.getAttributes(mine).isCopyLeftDef() && this.lOracle.getAttributes(license).isCopyLeftDef()) {
            ret.set("can't depend on a copy left license: " + license + " used by " + coo);
        }
        return (String)NonnullCheck._nn((Object)ret.get());
    }

    public void checkCompatibility() {
        this.coordinates2License.checkCompatibility(this::checkCompatibility);
    }

    public void getHolder() {
        GetHolder gh = new GetHolder(this.lOracle, this.mlo, this.log);
        this.coordinates2License.getHolders(gh::getHolder);
    }

    public void summery() {
        this.coordinates2License.summery();
    }

    public void src() {
        SrcAccess src = new SrcAccess(this.lOracle, this.mlo, this.log, this.andIsOr);
        this.coordinates2License.fromSrc(src::check);
    }

    public void store() {
        JSONStartup.previousOut(this.coordinates2License);
    }

    public void jars() {
        JarAccess src = new JarAccess(this.lOracle, this.mlo, this.log, this.andIsOr);
        this.coordinates2License.fromJar(src::check);
    }

    public void computeLicense() {
        this.coordinates2License.update(this::compute);
    }

    private void compute(Coordinates coordinates, Coordinates2License.LiCo liCo) {
        MappedLicense sum;
        MappedLicense t4;
        MappedLicense t3;
        MappedLicense t2;
        MappedLicense byCoo = this.lOracle.getByCoordinates(coordinates);
        liCo.setByCoordinates(byCoo);
        MappedLicense byPom = liCo.getMavenLicenses().stream().map(this::mavenLicenseToLicense).reduce(MappedLicense.empty(), (a, b) -> new And(this.lOracle, this.log, this.andIsOr).and((MappedLicense)a, (MappedLicense)b));
        liCo.setPomLicense(byPom);
        LicenseFromText lft = new LicenseFromText(this.lOracle);
        MappedLicense t1 = lft.getLicense(liCo.getLicenseTxt());
        if (t1.isPresent()) {
            this.log.debug("[woo] " + coordinates + " -> " + t1);
            liCo.setLicenseTxtLicense(t1);
        }
        if ((t2 = lft.getLicense(liCo.getPomHeader())).isPresent()) {
            this.log.debug("[woo] " + coordinates + " -> " + t2);
            liCo.setPomHeaderLicense(t2);
        }
        if ((t3 = lft.getLicense(liCo.getHeaderTxt())).isPresent()) {
            this.log.debug("[woo] " + coordinates + " -> " + t3);
            liCo.setHeaderLicense(t3);
        }
        if ((t4 = lft.getLicense(liCo.getNotice())).isPresent()) {
            this.log.debug("[woo] " + coordinates + " -> " + t4);
            liCo.setNoticeLicense(t4);
        }
        if ((sum = new Decider().decide(byCoo, byPom, t1, t2, t3, t4)).isPresent()) {
            liCo.setLicense(sum);
            return;
        }
        this.log.debug("searching in in content for " + coordinates);
        MappedLicense byPomHeader = new ContentToLicense(this.lOracle, "by pom header", this.log, this.andIsOr).findLicenses(liCo.getPomHeader());
        liCo.setPomHeaderLicense(byPomHeader);
        MappedLicense byLicenseTxt = new ContentToLicense(this.lOracle, "by license file", this.log, this.andIsOr).findLicenses(liCo.getLicenseTxt());
        liCo.setLicenseTxtLicense(byLicenseTxt);
        MappedLicense byHeader = new ContentToLicense(this.lOracle, "by file header", this.log, this.andIsOr).findLicenses(liCo.getHeaderTxt());
        liCo.setHeaderLicense(byHeader);
        MappedLicense byNotice = new ContentToLicense(this.lOracle, "by notice", this.log, this.andIsOr).findLicenses(liCo.getNotice());
        liCo.setNoticeLicense(byNotice);
        sum = new Decider().decide(byCoo, byPom, byPomHeader, byLicenseTxt, byHeader, byNotice);
        liCo.setLicense(sum);
        this.log.debug("done found?: " + sum.toString());
    }

    public void computeHolder() {
        this.coordinates2License.update(this::computeHolder);
    }

    private void computeHolder(Coordinates coordinates, Coordinates2License.LiCo liCo) {
        Optional<CopyrightHolder> ret = liCo.getMavenLicenses().stream().map(ml -> ContentToLicense.copyRightPattern.matcher((CharSequence)NonnullCheck._orElseGet((Object)ml.getComment(), (Object)""))).filter(Matcher::matches).map(m -> new CopyrightHolder((String)NonnullCheck._nn((Object)m.group("year")), (String)NonnullCheck._nn((Object)m.group("holder")))).findAny();
        if (ret.isPresent()) {
            liCo.setHolder(ret);
            return;
        }
        ret = new ContentToLicense(this.lOracle, "by license file", this.log, this.andIsOr).getHolder(liCo.getLicenseTxt());
        if (ret.isPresent()) {
            liCo.setHolder(ret);
            return;
        }
        ret = new ContentToLicense(this.lOracle, "by header file", this.log, this.andIsOr).getHolder(liCo.getHeaderTxt());
        if (ret.isPresent()) {
            liCo.setHolder(ret);
            return;
        }
        ret = new ContentToLicense(this.lOracle, "by notice file", this.log, this.andIsOr).getHolder(liCo.getNotice());
        if (ret.isPresent()) {
            liCo.setHolder(ret);
        }
    }

    public void getNotice() {
        GetHolder gh = new GetHolder(this.lOracle, this.mlo, this.log);
        this.coordinates2License.update(gh::getNotice);
    }

    public void getPomHeader() {
        SrcAccess src = new SrcAccess(this.lOracle, this.mlo, this.log, this.andIsOr);
        this.coordinates2License.fromSrc(src::getPomHeader);
    }

    private /* synthetic */ DependencyNode lambda$getNormalDependencies$70(ArtifactFilter artifactFilter) throws DependencyGraphBuilderException {
        return (DependencyNode)NonnullCheck._nn((Object)this.dependencyGraphBuilder.buildDependencyGraph(this.mavenProject, artifactFilter));
    }
}

