/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import de.pfabulist.unchecked.Unchecked;
import de.pfabulist.unchecked.functiontypes.ConsumerE;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MappedLicense {
    @Nullable
    private final LicenseID license;
    private final String reason;
    private final List<MappedLicense> diffOver = new ArrayList<MappedLicense>();
    private static final MappedLicense empty = new MappedLicense();

    private MappedLicense() {
        this.license = null;
        this.reason = "";
    }

    private MappedLicense(LicenseID licenseID, String reason) {
        this.license = licenseID;
        this.reason = reason;
        if (reason.isEmpty()) {
            throw new IllegalArgumentException("can't have a MappedLicense without reason");
        }
    }

    public MappedLicense(String reason) {
        this.license = null;
        this.reason = reason;
        if (reason.isEmpty()) {
            throw new IllegalArgumentException("can't have a MappedLicense without reason");
        }
    }

    public static MappedLicense empty() {
        return empty;
    }

    public static MappedLicense of(LicenseID licenseID, String reason) {
        return new MappedLicense(licenseID, reason);
    }

    public static MappedLicense of(Optional<LicenseID> licenseID, String reason) {
        return licenseID.map(l -> MappedLicense.of(l, reason)).orElse(MappedLicense.empty());
    }

    public boolean isPresent() {
        return this.license != null;
    }

    public LicenseID orElseThrow(Supplier<Exception> ex) {
        if (!this.isPresent()) {
            throw Unchecked.u((Throwable)((Throwable)NonnullCheck._nn((Object)ex.get())));
        }
        return (LicenseID)NonnullCheck._nn((Object)this.license);
    }

    public void ifPresent(ConsumerE<LicenseID, Exception> con) {
        if (this.isPresent()) {
            con.accept((Object)this.license);
        }
    }

    public MappedLicense addReason(String more) {
        if (!this.isPresent()) {
            return MappedLicense.empty();
        }
        if (more.isEmpty()) {
            return this;
        }
        return new MappedLicense((LicenseID)NonnullCheck._nn((Object)this.license), this.reason + " && " + more);
    }

    public String toString() {
        if (this.isPresent()) {
            String diff = "";
            if (!this.diffOver.isEmpty()) {
                diff = "!override!  [" + this.diffOver.stream().map(Object::toString).collect(Collectors.joining()) + "]";
            }
            return NonnullCheck._nn((Object)this.license) + " [" + this.reason + "]" + diff;
        }
        return "-";
    }

    public String getReason() {
        return this.reason;
    }

    public Optional<LicenseID> noReason() {
        return Optional.ofNullable(this.license);
    }

    @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedLicense that = (MappedLicense)o;
        return this.license != null ? this.license.equals(that.license) : that.license == null;
    }

    public int hashCode() {
        return this.license != null ? this.license.hashCode() : 0;
    }

    public <U> U orElse(Function<LicenseID, U> f, U els) {
        if (this.isPresent()) {
            return (U)NonnullCheck._nn(f.apply((LicenseID)NonnullCheck._nn((Object)this.license)));
        }
        return els;
    }

    public static MappedLicense empty(String s) {
        return new MappedLicense(s);
    }

    public void addOver(MappedLicense other) {
        if (this == other) {
            return;
        }
        if (other.isPresent() && !this.equals(other)) {
            this.diffOver.add(other);
        }
        other.diffOver.forEach(over -> {
            if (!this.equals(over)) {
                this.diffOver.add((MappedLicense)over);
            }
        });
    }

    public void addOverFrom(MappedLicense other) {
        other.diffOver.forEach(over -> {
            if (this.equals(over)) {
                this.diffOver.add((MappedLicense)over);
            }
        });
    }
}

