/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.frex.CharacterClass;
import de.pfabulist.frex.Frex;
import de.pfabulist.loracle.attribution.CopyrightHolder;
import de.pfabulist.loracle.license.And;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.license.MappedLicense;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentToLicense {
    public static final Pattern copyRightPattern = Frex.or((Frex[])new Frex[]{Frex.txt((String)"Copyright ")}).then((Frex)Frex.txt((String)"(C) ").zeroOrOnce()).then(Frex.or((Frex[])new Frex[]{Frex.number(), Frex.txt((char)'-'), Frex.txt((char)','), Frex.whitespace()}).oneOrMore().var("year")).then((Frex)Frex.txt((char)' ')).then((Frex)Frex.txt((String)"(C) ").zeroOrOnce()).then(Frex.anyBut((CharacterClass)Frex.txt((char)'\n')).oneOrMore().var("holder")).buildCaseInsensitivePattern();
    private final LOracle lOracle;
    private final String dscr;
    private final And and;
    private final Findings log;
    public static final Pattern page = Frex.or((Frex[])new Frex[]{Frex.txt((String)"http://"), Frex.txt((String)"https://")}).then(Frex.any().oneOrMore().lazy()).group("addr").then((Frex)Frex.txt((char)'.').zeroOrOnce()).then(Frex.or((Frex[])new Frex[]{Frex.txt((char)' '), Frex.txt((char)'\n'), Frex.txt((char)'\r')})).buildCaseInsensitivePattern();
    private static final Frex ws = Frex.or((Frex[])new Frex[]{Frex.whitespace(), Frex.txt((char)'\n'), Frex.txt((char)'\r')}).oneOrMore();
    private static final Pattern apache2 = Frex.txt((String)"Apache").then(ws).then(Frex.txt((String)"License")).then(ws).then(Frex.txt((String)"Version")).then(ws).then(Frex.txt((String)"2.0")).buildCaseInsensitivePattern();

    public ContentToLicense(LOracle lOracle, String dscr, Findings log, boolean andIsOr) {
        this.lOracle = lOracle;
        this.dscr = dscr;
        this.and = new And(lOracle, log, andIsOr);
        this.log = log;
    }

    public MappedLicense toLicense(String str) {
        if (str.isEmpty()) {
            return MappedLicense.empty("<no file found>");
        }
        return this.and.and(this.byUrl(str), this.byNamePattern(str));
    }

    public MappedLicense byUrl(String str) {
        Matcher matcher = page.matcher(str);
        MappedLicense ret = MappedLicense.empty();
        while (matcher.find()) {
            ret = this.and.and(ret, this.lOracle.getByUrl((String)NonnullCheck._nn((Object)matcher.group("addr"))).addReason(this.dscr));
        }
        return ret;
    }

    public MappedLicense byNamePattern(String str) {
        if (apache2.matcher(str).find()) {
            return MappedLicense.of(this.lOracle.getOrThrowByName("apache-2"), this.dscr);
        }
        if (str.contains("COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0")) {
            return MappedLicense.of(this.lOracle.getOrThrowByName("cddl-1.0"), this.dscr);
        }
        if (str.contains("The Apache Software License, Version 1.1")) {
            return MappedLicense.of(this.lOracle.getOrThrowByName("apache-1.1"), this.dscr);
        }
        return MappedLicense.empty();
    }

    public MappedLicense findLicenses(String str) {
        MappedLicense name = this.lOracle.findLongNames(this.and, str);
        MappedLicense url = this.byUrl(str);
        return this.and.and(name, url);
    }

    public Optional<CopyrightHolder> getHolder(String str) {
        Matcher matcher = copyRightPattern.matcher(str);
        if (matcher.find()) {
            CopyrightHolder ch = new CopyrightHolder((String)NonnullCheck._nn((Object)matcher.group("year")), (String)NonnullCheck._nn((Object)matcher.group("holder")));
            return Optional.of(ch);
        }
        return Optional.empty();
    }
}

