/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.attribution;

import de.pfabulist.frex.CharacterClass;
import de.pfabulist.frex.Frex;
import de.pfabulist.kleinod.nio.Filess;
import de.pfabulist.loracle.attribution.GetHolder;
import de.pfabulist.loracle.attribution.LicenseWriter;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.Coordinates2License;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.loracle.mojo.MavenLicenseOracle;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Pattern;

public class JarAccess {
    private final LOracle lOracle;
    private final MavenLicenseOracle mlo;
    private final Findings log;
    private final boolean andIsOr;
    private static Pattern licensePattern = Frex.or((Frex[])new Frex[]{Frex.txt((String)"LICENSE"), Frex.txt((String)"META-INF/LICENSE")}).then((Frex)Frex.any().zeroOrMore()).buildCaseInsensitivePattern();
    static Pattern copyRightPattern = Frex.or((Frex[])new Frex[]{Frex.txt((String)"Copyright ")}).then((Frex)Frex.txt((String)"(C) ").zeroOrOnce()).then(Frex.or((Frex[])new Frex[]{Frex.number(), Frex.txt((char)'-'), Frex.txt((char)','), Frex.whitespace()}).oneOrMore().var("year")).then((Frex)Frex.txt((char)' ')).then(Frex.anyBut((CharacterClass)Frex.txt((char)'\n')).oneOrMore().var("holder")).buildCaseInsensitivePattern();

    public JarAccess(LOracle lOracle, MavenLicenseOracle mlo, Findings log, boolean andIsOr) {
        this.lOracle = lOracle;
        this.mlo = mlo;
        this.log = log;
        this.andIsOr = andIsOr;
    }

    public void check(Coordinates coo, Coordinates2License.LiCo lico) {
        Path src = this.mlo.getArtifact(coo);
        if (!Files.exists(src, new LinkOption[0])) {
            this.log.warn("no jar available " + coo);
            return;
        }
        try (InputStream in = Filess.newInputStream((Path)src, (OpenOption[])new OpenOption[0]);){
            String file = GetHolder.unzipToString(in, licensePattern);
            if (file.isEmpty()) {
                this.log.debug("artifact source" + coo + " has no license file");
                return;
            }
            this.log.debug(coo.toString() + " found license file in jar");
            lico.setLicenseTxt(file);
            new LicenseWriter().write(coo, "license", file);
        }
        catch (IOException e) {
            this.log.warn((CharSequence)NonnullCheck._orElseGet((Object)e.getMessage(), (Object)"pattern problem"));
        }
    }
}

