/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.frex.CharacterClass;
import de.pfabulist.frex.Frex;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;

public class Coordinates {
    private final String coo;

    public Coordinates(String groupId, String artifactId, String version) {
        this.coo = groupId + ":" + artifactId + ":" + version;
        if (groupId.isEmpty() || artifactId.isEmpty() || version.isEmpty()) {
            throw new IllegalArgumentException("not a legal coordinates, one of group, artifact, version is empty");
        }
        if (groupId.contains(":") || artifactId.contains(":") || version.contains(":")) {
            throw new IllegalArgumentException("not a legal coordinates, one of group, artifact, contains a ':' ");
        }
    }

    public static Coordinates valueOf(String str) {
        String[] parts = str.split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException("not legal coordinates group:arti:version, got: " + str);
        }
        if (parts.length == 3) {
            return new Coordinates((String)NonnullCheck._nn((Object)parts[0]), (String)NonnullCheck._nn((Object)parts[1]), (String)NonnullCheck._nn((Object)parts[2]));
        }
        if (parts.length == 4) {
            return new Coordinates((String)NonnullCheck._nn((Object)parts[0]), (String)NonnullCheck._nn((Object)parts[1]), (String)NonnullCheck._nn((Object)parts[3]));
        }
        if (parts.length == 5) {
            return new Coordinates((String)NonnullCheck._nn((Object)parts[0]), (String)NonnullCheck._nn((Object)parts[1]), (String)NonnullCheck._nn((Object)parts[4]));
        }
        throw new IllegalArgumentException("not legal coordinates, too many ':' " + str);
    }

    public static Coordinates valueOf(Artifact arti) {
        return new Coordinates((String)NonnullCheck._nn((Object)arti.getGroupId()), (String)NonnullCheck._nn((Object)arti.getArtifactId()), (String)NonnullCheck._nn((Object)arti.getVersion()));
    }

    public String getGroupId() {
        String[] parts = this.coo.split(":");
        return (String)NonnullCheck._nn((Object)parts[0]);
    }

    public String getArtifactId() {
        String[] parts = this.coo.split(":");
        return (String)NonnullCheck._nn((Object)parts[1]);
    }

    public String getVersion() {
        String[] parts = this.coo.split(":");
        return (String)NonnullCheck._nn((Object)parts[2]);
    }

    @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinates that = (Coordinates)o;
        return this.coo.equals(that.coo);
    }

    public int hashCode() {
        return this.coo.hashCode();
    }

    public String toString() {
        return this.coo;
    }

    public boolean matches(Coordinates other) {
        if (!this.coo.contains("*")) {
            return this.equals(other);
        }
        ArrayList<String> txt = new ArrayList<String>(Arrays.asList(this.coo.split("\\*")));
        if (this.coo.endsWith("*")) {
            txt.add("");
        }
        if (((String)NonnullCheck._nn(txt.get(0))).isEmpty()) {
            throw new IllegalArgumentException("group must not start with *");
        }
        Pattern pat = txt.subList(1, txt.size()).stream().map(Frex::txt).collect(Collectors.reducing(Frex.txt((String)((String)NonnullCheck._nn(txt.get(0)))), (f, g) -> f.then((Frex)Frex.anyBut((CharacterClass)Frex.txt((char)':')).zeroOrMore()).then(g))).buildCaseInsensitivePattern();
        return pat.matcher(other.coo).matches();
    }
}

