/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.attribution;

import de.pfabulist.frex.Frex;
import de.pfabulist.kleinod.nio.Filess;
import de.pfabulist.kleinod.nio.IO;
import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.loracle.attribution.CopyrightHolder;
import de.pfabulist.loracle.license.ContentToLicense;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.Coordinates2License;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.loracle.mojo.MavenLicenseOracle;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import de.pfabulist.unchecked.Unchecked;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.model.License;

public class GetHolder {
    private static Pattern noticePattern = Frex.txt((String)"META-INF/NOTICE").then((Frex)Frex.any().zeroOrMore()).buildCaseInsensitivePattern();
    static Pattern commentsCopyRightPattern = Frex.or((Frex[])new Frex[]{Frex.txt((String)"Copyright ")}).then(Frex.or((Frex[])new Frex[]{Frex.number(), Frex.txt((char)'-'), Frex.txt((char)','), Frex.whitespace()}).oneOrMore().var("year")).then((Frex)Frex.txt((char)' ')).then(Frex.any().oneOrMore().var("holder")).buildCaseInsensitivePattern();
    private final LOracle lOracle;
    private final MavenLicenseOracle mlo;
    private final Findings log;

    public GetHolder(LOracle lOracle, MavenLicenseOracle mlo, Findings log) {
        this.lOracle = lOracle;
        this.mlo = mlo;
        this.log = log;
    }

    public Optional<CopyrightHolder> getHolder(Coordinates coo, String license) {
        List<License> mavenLicenses = this.mlo.getMavenLicense(coo);
        Optional<CopyrightHolder> ret = mavenLicenses.stream().map(ml -> commentsCopyRightPattern.matcher((CharSequence)NonnullCheck._orElseGet((Object)ml.getComments(), (Object)""))).filter(Matcher::matches).map(m -> new CopyrightHolder((String)NonnullCheck._nn((Object)m.group("year")), (String)NonnullCheck._nn((Object)m.group("holder")))).findAny();
        if (ret.isPresent()) {
            return ret;
        }
        if (!this.lOracle.getOrThrowByName(license).equals(this.lOracle.getOrThrowByName("apache-2"))) {
            return Optional.empty();
        }
        return this.getApacheCopyrightHolder(coo);
    }

    public void getNotice(Coordinates coo, Coordinates2License.LiCo lico) {
        Path jar = this.mlo.getArtifact(coo);
        try (InputStream in = Filess.newInputStream((Path)jar, (OpenOption[])new OpenOption[0]);){
            String notice = GetHolder.unzipToString(in, noticePattern);
            lico.setNotice(notice);
        }
        catch (IOException e) {
            this.log.warn((CharSequence)NonnullCheck._orElseGet((Object)e.getMessage(), (Object)"pattern problem"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<CopyrightHolder> getApacheCopyrightHolder(Coordinates coo) {
        Path jar = this.mlo.getArtifact(coo);
        try (InputStream in = Filess.newInputStream((Path)jar, (OpenOption[])new OpenOption[0]);){
            String notice = GetHolder.unzipToString(in, noticePattern);
            if (notice.isEmpty()) {
                this.log.warn("artifact " + coo + " licensed to apache-2 has not notice.txt file");
                Optional<CopyrightHolder> optional = Optional.empty();
                return optional;
            }
            Matcher ch = ContentToLicense.copyRightPattern.matcher(notice);
            if (!ch.find()) {
                this.log.warn("notice file has no recognizable holder");
                Optional<CopyrightHolder> optional = Optional.empty();
                return optional;
            }
            Optional<CopyrightHolder> optional = Optional.of(new CopyrightHolder((String)NonnullCheck._nn((Object)ch.group("year")), (String)NonnullCheck._nn((Object)ch.group("holder"))));
            return optional;
        }
        catch (IOException e) {
            this.log.warn((CharSequence)NonnullCheck._orElseGet((Object)e.getMessage(), (Object)"pattern problem"));
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String unzipToString(InputStream is, Pattern pat) {
        try (ZipInputStream zin = new ZipInputStream(is);){
            ZipEntry ze;
            while ((ze = zin.getNextEntry()) != null) {
                if (pat.matcher(ze.getName()).matches()) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IO.copy((InputStream)zin, (OutputStream)out);
                    String string = Strings.newString((byte[])out.toByteArray());
                    return string;
                }
                zin.closeEntry();
            }
            return "";
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
    }
}

