/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.mojo;

import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import de.pfabulist.unchecked.NullCheck;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenLicenseOracle {
    private final Log log;
    private final Path localRepo;

    public MavenLicenseOracle(Log log, Path localRepo) {
        this.log = log;
        this.localRepo = localRepo;
    }

    public List<License> getMavenLicense(Coordinates coo) {
        while (true) {
            Path pom;
            List<License> licenses;
            if (!(licenses = this.extractLicense(pom = this.getPom(coo))).isEmpty()) {
                this.log.debug((CharSequence)"      licenses found ");
                licenses.forEach(l -> this.log.debug((CharSequence)("         " + (String)NullCheck._orElseGet((Object)l.getName(), (Object)"-") + " : " + (String)NullCheck._orElseGet((Object)l.getUrl(), (Object)"-"))));
                return licenses;
            }
            this.log.debug((CharSequence)("    no licenses found in " + coo));
            Optional<Coordinates> parentCoo = this.extractParent(pom);
            if (!parentCoo.isPresent()) break;
            coo = (Coordinates)NonnullCheck._nn((Object)parentCoo.get());
            this.log.debug((CharSequence)("          going to parent: " + coo));
        }
        this.log.debug((CharSequence)"          no parent, i,e. no license found");
        return Collections.emptyList();
    }

    private Path getPom(Coordinates coords) {
        Path ret = this.localRepo;
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getGroupId().replace('.', '/')));
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getArtifactId()));
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getVersion()));
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getArtifactId() + "-" + coords.getVersion() + ".pom"));
        return ret;
    }

    public Path getArtifact(Coordinates coords) {
        Path ret = this.localRepo;
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getGroupId().replace('.', '/')));
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getArtifactId()));
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getVersion()));
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getArtifactId() + "-" + coords.getVersion() + ".jar"));
        return ret;
    }

    public Path getSrc(Coordinates coords) {
        Path ret = this.localRepo;
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getGroupId().replace('.', '/')));
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getArtifactId()));
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getVersion()));
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getArtifactId() + "-" + coords.getVersion() + "-sources.jar"));
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<License> extractLicense(Path pom) {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (BufferedReader pathReader = Files.newBufferedReader(pom);){
            Model pomModel = (Model)NonnullCheck._nn((Object)reader.read((Reader)pathReader));
            List list = (List)NonnullCheck._nn((Object)pomModel.getLicenses());
            return list;
        }
        catch (IOException | XmlPullParserException e) {
            this.log.warn((CharSequence)("error extracting license from pom " + e));
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Optional<Coordinates> extractParent(Path pom) {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (BufferedReader pathReader = Files.newBufferedReader(pom);){
            Model pomModel = (Model)NonnullCheck._nn((Object)reader.read((Reader)pathReader));
            Parent parent = pomModel.getParent();
            if (parent == null) {
                Optional<Coordinates> optional2 = Optional.empty();
                return optional2;
            }
            Optional<Coordinates> optional = Optional.of(new Coordinates((String)NonnullCheck._nn((Object)parent.getGroupId()), (String)NonnullCheck._nn((Object)parent.getArtifactId()), (String)NonnullCheck._nn((Object)parent.getVersion())));
            return optional;
        }
        catch (IOException | XmlPullParserException e) {
            this.log.warn((CharSequence)("error extracting parent from pom " + e));
            return Optional.empty();
        }
    }
}

