/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.mojo;

import de.pfabulist.loracle.attribution.GetHolder;
import de.pfabulist.loracle.attribution.JarAccess;
import de.pfabulist.loracle.attribution.SrcAccess;
import de.pfabulist.loracle.buildup.JSONStartup;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.Coordinates2License;
import de.pfabulist.loracle.license.Decider;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.MappedLicense;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.loracle.mojo.LicenseDeclaration;
import de.pfabulist.loracle.mojo.MavenLicenseOracle;
import de.pfabulist.loracle.mojo.UrlDeclaration;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import de.pfabulist.unchecked.NullCheck;
import de.pfabulist.unchecked.Unchecked;
import de.pfabulist.unchecked.functiontypes.ConsumerE;
import de.pfabulist.unchecked.functiontypes.FunctionE;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Build;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class LicenseCheckMojo {
    private final Findings log;
    private final MavenLicenseOracle mlo;
    private final LOracle lOracle;
    private final MavenProject mavenProject;
    private final DependencyGraphBuilder dependencyGraphBuilder;
    private final boolean andIsOr;
    private Optional<Coordinates> self = Optional.empty();
    private final Coordinates2License coordinates2License;

    public LicenseCheckMojo(Findings log, Path localRepo, MavenProject project, DependencyGraphBuilder dependencyGraphBuilder, boolean andIsOr) {
        this.log = log;
        this.dependencyGraphBuilder = dependencyGraphBuilder;
        this.mlo = new MavenLicenseOracle(log, localRepo);
        this.lOracle = JSONStartup.start().spread();
        this.mavenProject = project;
        this.andIsOr = andIsOr;
        log.info("---------------------------------------");
        log.info("      loracle license check            ");
        log.info("---------------------------------------");
        this.coordinates2License = JSONStartup.previous(andIsOr);
        this.coordinates2License.setLog(log);
    }

    public void config(List<LicenseDeclaration> licenseDeclarations, List<UrlDeclaration> urlDeclarations, int allowUrlsCheckedDaysBefore) {
        this.configLicenseDeclarations(licenseDeclarations);
        this.configUrlDeclarations(urlDeclarations);
        this.configCheckUrls(allowUrlsCheckedDaysBefore);
    }

    private void configCheckUrls(int allowUrlsCheckedDaysBefore) {
        if (allowUrlsCheckedDaysBefore > 0) {
            this.lOracle.allowUrlsCheckedDaysBefore(allowUrlsCheckedDaysBefore);
        }
    }

    private void configUrlDeclarations(List<UrlDeclaration> urlDeclarations) {
        urlDeclarations.forEach(ud -> {
            LicenseID license = this.lOracle.getOrThrowByName(ud.getLicense());
            this.lOracle.addUrlCheckedAt(license, ud.getUrl(), ud.getCheckedAt());
            this.log.debug("setting " + ud.getUrl() + " -> " + license + ", check at " + ud.getCheckedAt());
        });
    }

    private void configLicenseDeclarations(List<LicenseDeclaration> licenseDeclarations) {
        licenseDeclarations.forEach(excl -> {
            Coordinates coo = excl.getCoordinates();
            LicenseID license = this.lOracle.getOrThrowByName(excl.getLicense());
            this.lOracle.addLicenseForArtifact(coo, license);
            this.log.debug("setting " + coo + " -> " + license);
        });
    }

    public void getDependencies() {
        this.getPluginsAndTheirDependencies();
        this.getNormalDependencies();
    }

    private void getNormalDependencies() {
        ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("test");
        DependencyNode rootNode = (DependencyNode)Unchecked.u(() -> this.lambda$getNormalDependencies$67((ArtifactFilter)artifactFilter));
        rootNode.accept(new DependencyNodeVisitor(){

            public boolean visit(DependencyNode dependencyNode) {
                Artifact a = (Artifact)NonnullCheck._nn((Object)dependencyNode.getArtifact());
                Coordinates coo = Coordinates.valueOf(a);
                LicenseCheckMojo.this.coordinates2License.add(coo);
                LicenseCheckMojo.this.coordinates2License.updateScope(coo, (String)NullCheck._orElseGet((Object)a.getScope(), (Object)"compile"));
                if (!LicenseCheckMojo.this.self.isPresent()) {
                    LicenseCheckMojo.this.self = Optional.of(coo);
                }
                return true;
            }

            public boolean endVisit(DependencyNode dependencyNode) {
                return true;
            }
        });
    }

    private void getPluginsAndTheirDependencies() {
        ((Build)NonnullCheck._nn((Object)this.mavenProject.getBuild())).getPlugins().forEach(plugin -> {
            Coordinates plugCoo = new Coordinates((String)NonnullCheck._nn((Object)plugin.getGroupId()), (String)NonnullCheck._nn((Object)plugin.getArtifactId()), (String)NonnullCheck._nn((Object)plugin.getVersion()));
            this.coordinates2License.add(plugCoo);
            this.coordinates2License.updateScope(plugCoo, "plugin");
            List deps = (List)NonnullCheck._nn((Object)plugin.getDependencies());
            deps.forEach(d -> {
                Coordinates dCoo = new Coordinates((String)NonnullCheck._nn((Object)d.getGroupId()), (String)NonnullCheck._nn((Object)d.getArtifactId()), (String)NonnullCheck._nn((Object)d.getVersion()));
                this.coordinates2License.add(dCoo);
                this.coordinates2License.updateScope(dCoo, "plugin");
            });
        });
    }

    public void determineLicenses() {
        this.log.debug("-- determine licenses --");
        this.coordinates2License.determineLicenses((FunctionE<Coordinates, MappedLicense, Exception>)((FunctionE)this::licenseMapping));
    }

    private MappedLicense licenseMapping(Coordinates coo) {
        this.log.debug(coo.toString() + "    license is ...");
        List<License> mavenLicenses = this.mlo.getMavenLicense(coo);
        if (mavenLicenses.isEmpty()) {
            mavenLicenses = Collections.singletonList(new License());
        }
        MappedLicense byCoordinates = this.lOracle.getByCoordinates(coo);
        try {
            return mavenLicenses.stream().map(ml -> this.mavenLicenseToLicense(coo, byCoordinates, (License)ml)).collect(Collectors.reducing(MappedLicense.empty(), this::and));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return MappedLicense.empty();
        }
    }

    private MappedLicense mavenLicenseToLicense(Coordinates coo, MappedLicense byCoordinates, License mavenLicense) {
        Optional<String> name = Optional.ofNullable(mavenLicense.getName());
        MappedLicense byName = name.map(this.lOracle::getByName).orElse(MappedLicense.empty());
        Optional<String> url = Optional.ofNullable(mavenLicense.getUrl());
        MappedLicense byUrl = url.map(this.lOracle::getByUrl).orElse(MappedLicense.empty());
        MappedLicense licenseID = new Decider(this.log).decide(byCoordinates, byName, byUrl);
        if (!licenseID.isPresent()) {
            this.log.warn("[pom] artifact: " + coo + "   has one unprecise license");
            this.log.warn("[pom]    by coordinates : " + byCoordinates);
            this.log.warn("[pom]    by license name: " + name.orElse("-") + " -> " + byName);
            this.log.warn("[pom]    by license url : " + url.orElse("-") + " ->" + byUrl);
            this.log.warn("[pom] artifact: " + coo + "   has no or not precise enough license");
            name.ifPresent(n -> this.log.warn("[pom]   it could be (by name) " + this.lOracle.guessByName((String)n)));
            url.ifPresent(u -> this.log.warn("[pom]   it could be (by url) " + this.lOracle.guessByUrl((String)u)));
        }
        return licenseID;
    }

    private MappedLicense and(MappedLicense l, MappedLicense r) {
        if (!l.isPresent()) {
            return r;
        }
        if (!r.isPresent()) {
            return l;
        }
        AtomicReference<MappedLicense> ret = new AtomicReference<MappedLicense>(MappedLicense.empty());
        l.ifPresent((ConsumerE<LicenseID, Exception>)((ConsumerE)left -> r.ifPresent((ConsumerE<LicenseID, Exception>)((ConsumerE)right -> {
            if (this.andIsOr) {
                ret.set(MappedLicense.of(this.lOracle.getOr((LicenseID)left, (LicenseID)right), "dual license or'ed (" + l.getReason() + "), (" + r.getReason() + ")"));
            } else {
                this.log.warn("is that really <" + ret + "> or should that be <" + this.lOracle.getOr((LicenseID)left, (LicenseID)right) + ">");
                ret.set(MappedLicense.of(this.lOracle.getAnd((LicenseID)left, (LicenseID)right), "dual license and'ed (" + l.getReason() + "), (" + r.getReason() + ")"));
            }
        }))));
        return (MappedLicense)NonnullCheck._nn((Object)ret.get());
    }

    public String checkCompatibility(Coordinates coo, String licenseStr) {
        LicenseID license = this.lOracle.getOrThrowByName(licenseStr);
        AtomicReference<String> ret = new AtomicReference<String>("");
        this.lOracle.getAttributes(license).isFedoraApproved().ifPresent(fed -> {
            if (!fed.booleanValue()) {
                ret.set("bad license " + license + " used by " + coo + "  (not approved by fedora)");
            }
        });
        if (!this.self.isPresent()) {
            return "";
        }
        Optional<Coordinates2License.LiCo> info = this.coordinates2License.get((Coordinates)NonnullCheck._nn((Object)this.self.get()));
        if (!info.isPresent() || !((Coordinates2License.LiCo)NonnullCheck._nn((Object)info.get())).getLicense().isPresent()) {
            return "no license on current artifact";
        }
        LicenseID mine = this.lOracle.getOrThrowByName((String)NonnullCheck._nn((Object)((Coordinates2License.LiCo)NonnullCheck._nn((Object)info.get())).getLicense().get()));
        if (mine.equals(license)) {
            return "";
        }
        if (this.lOracle.getAttributes(mine).isCopyLeftDef()) {
            this.lOracle.getAttributes(license).isGpl2Compatible().ifPresent(gc -> {
                if (!gc.booleanValue()) {
                    ret.set("not gpl2 compatible: " + license + " used by " + coo);
                }
            });
            this.lOracle.getAttributes(license).isGpl3Compatible().ifPresent(gc -> {
                if (!gc.booleanValue()) {
                    ret.set("not gpl2 compatible: " + license + " used by " + coo);
                }
            });
        }
        if (!this.lOracle.getAttributes(mine).isCopyLeftDef() && this.lOracle.getAttributes(license).isCopyLeftDef()) {
            ret.set("can't depend on a copy left license: " + license + " used by " + coo);
        }
        return (String)NonnullCheck._nn((Object)ret.get());
    }

    public void checkCompatibility() {
        this.coordinates2License.checkCompatibility(this::checkCompatibility);
    }

    public void getHolder() {
        GetHolder gh = new GetHolder(this.lOracle, this.mlo, this.log);
        this.coordinates2License.getHolders(gh::getHolder);
    }

    public void summery() {
        this.coordinates2License.summery();
    }

    public void src() {
        SrcAccess src = new SrcAccess(this.lOracle, this.mlo, this.log);
        this.coordinates2License.fromSrc(src::check);
    }

    public void store() {
        JSONStartup.previousOut(this.coordinates2License);
    }

    public void jars() {
        JarAccess src = new JarAccess(this.lOracle, this.mlo, this.log);
        this.coordinates2License.fromJar(src::check);
    }

    private /* synthetic */ DependencyNode lambda$getNormalDependencies$67(ArtifactFilter artifactFilter) throws DependencyGraphBuilderException {
        return (DependencyNode)NonnullCheck._nn((Object)this.dependencyGraphBuilder.buildDependencyGraph(this.mavenProject, artifactFilter));
    }
}

