/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.frex.CharacterClass;
import de.pfabulist.frex.Frex;
import de.pfabulist.loracle.license.CompositeLicense;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.license.LicenseExclude;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.LicenseIDs;
import de.pfabulist.loracle.license.SingleLicense;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class SPDXParser {
    private final LOracle lOracle;
    static Frex word = Frex.or((Frex[])new Frex[]{Frex.alphaNum(), Frex.txt((char)'-').or((CharacterClass)Frex.txt((char)'.'))}).oneOrMore();
    static Pattern namePattern = word.var("name").then((Frex)Frex.whitespace().zeroOrMore()).then((Frex)Frex.txt((char)'+').var("plus").zeroOrOnce()).then((Frex)Frex.whitespace().then(Frex.txt((String)"WITH")).then(Frex.whitespace()).then(word.var("exception")).zeroOrOnce()).buildCaseInsensitivePattern();

    public SPDXParser(LOracle lOracle) {
        this.lOracle = lOracle;
    }

    public LicenseID parse(String in) {
        return this.liBuilder(this.tok(LOracle.trim(in)));
    }

    private Stream<Tok> tok(String in) {
        ArrayList<Tok> ret = new ArrayList<Tok>();
        Pattern first = Frex.any().zeroOrMore().lazy().var("before").then(Frex.or((Frex[])new Frex[]{Frex.txt((char)')').var("closed"), Frex.txt((char)'(').var("open"), Frex.fullWord((String)"or").var("or"), Frex.fullWord((String)"and").var("and")})).then(Frex.any().zeroOrMore().var("rest")).buildCaseInsensitivePattern();
        String rest = in;
        while (true) {
            Matcher matcher;
            if (!(matcher = first.matcher(rest)).matches()) break;
            this.parseSingleSPDX(ret, (String)NonnullCheck._nn((Object)matcher.group("before")));
            if (matcher.group("closed") != null) {
                ret.add(Tok.closed());
            } else if (matcher.group("open") != null) {
                ret.add(Tok.open());
            } else if (matcher.group("or") != null) {
                ret.add(Tok.or());
            } else if (matcher.group("and") != null) {
                ret.add(Tok.and());
            } else {
                throw new IllegalStateException("huh");
            }
            rest = (String)NonnullCheck._nn((Object)matcher.group("rest"));
        }
        this.parseSingleSPDX(ret, rest);
        return ret.stream();
    }

    public LicenseID getExtended(String nameExpr) {
        Matcher matcher = namePattern.matcher(nameExpr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("no such license: " + nameExpr);
        }
        String name = (String)NonnullCheck._nn((Object)matcher.group("name"));
        SingleLicense license = this.lOracle.getSingle(name).orElseThrow(() -> new IllegalArgumentException("no such license: " + name));
        boolean plus = matcher.group("plus") != null;
        Optional<LicenseExclude> exception = Optional.ofNullable(matcher.group("exception")).map(this.lOracle::getExceptionOrThrow);
        return this.lOracle.getOrLater(license, plus, exception);
    }

    private void parseSingleSPDX(List<Tok> ret, String posSPDX) {
        if (!(posSPDX = posSPDX.trim()).isEmpty()) {
            LicenseID extended = this.getExtended(posSPDX);
            ret.add(Tok.single(extended));
        }
    }

    LicenseID liBuilder(Stream<Tok> stream) {
        Stack<Parsed> stack = new Stack<Parsed>();
        stack.push(Parsed.start());
        stream.forEach(tok -> {
            if (tok.typ == TokTyp.openBracket) {
                stack.push(Parsed.start());
            } else if (tok.typ == TokTyp.closeBracket) {
                Parsed ex = (Parsed)NonnullCheck._nn(stack.pop());
                if (ex.op.isPresent()) {
                    throw new IllegalArgumentException("dangling operator");
                }
                Parsed before = (Parsed)NonnullCheck._nn(stack.pop());
                stack.push(before.value(this.lOracle, ex.license.orElseThrow(() -> new IllegalArgumentException("empty brackets")), true));
            } else if (tok.typ == TokTyp.text) {
                Parsed before = (Parsed)NonnullCheck._nn(stack.pop());
                stack.push(before.value(this.lOracle, tok.content.orElseThrow(() -> new IllegalStateException("text without content")), false));
            } else if (tok.typ == TokTyp.andTok) {
                Parsed before = (Parsed)NonnullCheck._nn(stack.pop());
                stack.push(before.and());
            } else if (tok.typ == TokTyp.orTok) {
                Parsed before = (Parsed)NonnullCheck._nn(stack.pop());
                stack.push(before.or());
            }
        });
        Parsed ret = (Parsed)NonnullCheck._nn(stack.pop());
        if (!stack.isEmpty()) {
            throw new IllegalStateException("not all brackets closed");
        }
        if (ret.op.isPresent()) {
            throw new IllegalStateException("dangling operator");
        }
        return ret.license.orElseThrow(() -> new IllegalStateException("positive parse result without license"));
    }

    public static class Parsed {
        final Optional<LicenseID> license;
        final Optional<TokTyp> op;
        final boolean closed;

        public Parsed(Optional<LicenseID> license, Optional<TokTyp> op) {
            this.license = license;
            this.op = op;
            this.closed = false;
        }

        public Parsed(LicenseID license, boolean closed) {
            this.license = Optional.of(license);
            this.op = Optional.empty();
            this.closed = closed;
        }

        public static Parsed start() {
            return new Parsed(Optional.empty(), Optional.empty());
        }

        public Parsed value(LOracle lOracle, LicenseID after, boolean closed) {
            if (!this.op.isPresent()) {
                if (this.license.isPresent()) {
                    throw new IllegalArgumentException("operator missing");
                }
                return new Parsed(after, closed);
            }
            LicenseID current = this.license.orElseThrow(() -> new IllegalStateException("license must be set here"));
            if (this.op.get() == TokTyp.andTok) {
                if (LicenseIDs.isOr(current)) {
                    CompositeLicense or = (CompositeLicense)current;
                    return new Parsed(Optional.of(lOracle.getOr(or.getLeft(), lOracle.getAnd(or.getRight(), after))), Optional.empty());
                }
                return new Parsed(Optional.of(lOracle.getAnd(current, after)), Optional.empty());
            }
            if (this.op.get() == TokTyp.orTok) {
                return new Parsed(Optional.of(lOracle.getOr(current, after)), Optional.empty());
            }
            throw new IllegalArgumentException("huh");
        }

        public Parsed and() {
            if (this.op.isPresent()) {
                throw new IllegalArgumentException("2 operators");
            }
            if (!this.license.isPresent()) {
                throw new IllegalArgumentException("no left side for operator");
            }
            return new Parsed(this.license, Optional.of(TokTyp.andTok));
        }

        public Parsed or() {
            if (this.op.isPresent()) {
                throw new IllegalArgumentException("2 operators");
            }
            if (!this.license.isPresent()) {
                throw new IllegalArgumentException("no left side for operator");
            }
            return new Parsed(this.license, Optional.of(TokTyp.orTok));
        }
    }

    public static class Tok {
        final TokTyp typ;
        final Optional<LicenseID> content;

        Tok(TokTyp typ, Optional<LicenseID> content) {
            this.typ = typ;
            this.content = content;
        }

        public static Tok open() {
            return new Tok(TokTyp.openBracket, Optional.empty());
        }

        public static Tok closed() {
            return new Tok(TokTyp.closeBracket, Optional.empty());
        }

        public static Tok and() {
            return new Tok(TokTyp.andTok, Optional.empty());
        }

        public static Tok or() {
            return new Tok(TokTyp.orTok, Optional.empty());
        }

        public static Tok single(LicenseID str) {
            return new Tok(TokTyp.text, Optional.of(str));
        }

        public String toString() {
            return (Object)((Object)this.typ) + this.content.toString();
        }
    }

    public static enum TokTyp {
        openBracket,
        closeBracket,
        andTok,
        orTok,
        text;

    }
}

